/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class KylinUserGroupService
implements IUserGroupService {
    @Autowired
    @Qualifier(value="userService")
    private UserService userService;
    @Autowired
    private AclEvaluate aclEvaluate;

    @Override
    public List<String> listAllAuthorities(String project) throws IOException {
        this.aclEvaluate.checkProjectAdminPermission(project);
        return this.getAllUserAuthorities();
    }

    List<String> getAllUserAuthorities() throws IOException {
        ArrayList<String> all = new ArrayList<String>();
        for (UserDetails userDetails : this.userService.listUsers()) {
            for (GrantedAuthority auth : userDetails.getAuthorities()) {
                if (all.contains(auth.getAuthority())) continue;
                all.add(auth.getAuthority());
            }
        }
        return all;
    }

    @Override
    public boolean exists(String name) throws IOException {
        return this.getAllUserAuthorities().contains(name);
    }
}

