/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @Autowired
    @Qualifier(value="userService")
    UserService userService;

    @RequestMapping(value={"/authentication"}, method={RequestMethod.POST}, produces={"application/json"})
    public UserDetails authenticate() {
        UserDetails userDetails = this.authenticatedUser();
        logger.debug("User login: {}", (Object)userDetails);
        return userDetails;
    }

    @RequestMapping(value={"/authentication"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserDetails authenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("authentication is null.");
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            return (UserDetails)authentication.getPrincipal();
        }
        if (authentication.getDetails() instanceof UserDetails) {
            return (UserDetails)authentication.getDetails();
        }
        return null;
    }
}

