/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.rest.service.UserGrantedAuthority;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ManagedUser
extends RootPersistentEntity
implements UserDetails {
    @JsonProperty
    private String username;
    @JsonProperty
    private String password;
    @JsonProperty
    @JsonSerialize(using=SimpleGrantedAuthoritySerializer.class)
    @JsonDeserialize(using=SimpleGrantedAuthorityDeserializer.class)
    private List<SimpleGrantedAuthority> authorities = Lists.newArrayList();
    @JsonProperty
    private boolean disabled = false;
    @JsonProperty
    private boolean defaultPassword = false;
    @JsonProperty
    private boolean locked = false;
    @JsonProperty
    private long lockedTime = 0L;
    @JsonProperty
    private int wrongTime = 0;
    private static final String DISABLED_ROLE = "--disabled--";

    public ManagedUser() {
    }

    public ManagedUser(@JsonProperty String username, @JsonProperty String password, @JsonProperty List<SimpleGrantedAuthority> authorities, @JsonProperty boolean disabled, @JsonProperty boolean defaultPassword, @JsonProperty boolean locked, @JsonProperty long lockedTime, @JsonProperty int wrongTime) {
        this.username = username;
        this.password = password;
        this.authorities = authorities;
        this.disabled = disabled;
        this.defaultPassword = defaultPassword;
        this.locked = locked;
        this.lockedTime = lockedTime;
        this.wrongTime = wrongTime;
        this.caterLegacy();
    }

    public ManagedUser(String username, String password, Boolean defaultPassword, String ... authoritiesStr) {
        this.username = username;
        this.password = password;
        this.setDefaultPassword(defaultPassword);
        this.authorities = Lists.newArrayList();
        for (String a : authoritiesStr) {
            this.authorities.add(new SimpleGrantedAuthority(a));
        }
        this.caterLegacy();
    }

    public ManagedUser(String username, String password, Boolean defaultPassword, Collection<? extends GrantedAuthority> grantedAuthorities) {
        this.username = username;
        this.password = password;
        this.setDefaultPassword(defaultPassword);
        this.setGrantedAuthorities(grantedAuthorities);
        this.caterLegacy();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void caterLegacy() {
        Iterator<SimpleGrantedAuthority> iterator = this.authorities.iterator();
        while (iterator.hasNext()) {
            if (!DISABLED_ROLE.equals(iterator.next().getAuthority())) continue;
            iterator.remove();
            this.disabled = true;
        }
    }

    public List<SimpleGrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public void setGrantedAuthorities(Collection<? extends GrantedAuthority> grantedAuthorities) {
        this.authorities = Lists.newArrayList();
        for (GrantedAuthority grantedAuthority : grantedAuthorities) {
            this.authorities.add(new SimpleGrantedAuthority(grantedAuthority.getAuthority()));
        }
    }

    public void addAuthoritie(String auth) {
        if (this.authorities == null) {
            this.authorities = Lists.newArrayList();
        }
        this.authorities.add(new SimpleGrantedAuthority(auth));
    }

    public void removeAuthoritie(String auth) {
        Preconditions.checkNotNull(this.authorities);
        this.authorities.remove(new SimpleGrantedAuthority(auth));
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(boolean defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getWrongTime() {
        return this.wrongTime;
    }

    public long getLockedTime() {
        return this.lockedTime;
    }

    public void increaseWrongTime() {
        int wrongTime = this.getWrongTime();
        if (wrongTime == 2) {
            this.setLocked(true);
            this.lockedTime = System.currentTimeMillis();
            this.wrongTime = 0;
        } else {
            this.wrongTime = wrongTime + 1;
        }
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return !this.locked;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ManagedUser other = (ManagedUser)((Object)obj);
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "ManagedUser [username=" + this.username + ", authorities=" + this.authorities + "]";
    }

    private static class SimpleGrantedAuthorityDeserializer
    extends JsonDeserializer<List<SimpleGrantedAuthority>> {
        private SimpleGrantedAuthorityDeserializer() {
        }

        public List<SimpleGrantedAuthority> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            UserGrantedAuthority[] ugaArray = (UserGrantedAuthority[])p.readValueAs(UserGrantedAuthority[].class);
            ArrayList sgaList = Lists.newArrayList();
            for (UserGrantedAuthority uga : ugaArray) {
                sgaList.add(new SimpleGrantedAuthority(uga.getAuthority()));
            }
            return sgaList;
        }
    }

    private static class SimpleGrantedAuthoritySerializer
    extends JsonSerializer<List<SimpleGrantedAuthority>> {
        private SimpleGrantedAuthoritySerializer() {
        }

        public void serialize(List<SimpleGrantedAuthority> value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            ArrayList ugaList = Lists.newArrayList();
            for (SimpleGrantedAuthority sga : value) {
                ugaList.add(new UserGrantedAuthority(sga.getAuthority()));
            }
            gen.writeObject((Object)ugaList);
        }
    }
}

