/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageCleanJobHbaseUtil {
    protected static final Logger logger = LoggerFactory.getLogger(StorageCleanJobHbaseUtil.class);

    public static void cleanUnusedHBaseTables(boolean delete, int deleteTimeout) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)kylinConfig);
        try (HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);){
            String namespace = kylinConfig.getHBaseStorageNameSpace();
            String tableNamePrefix = namespace.equals("default") || namespace.equals("") ? kylinConfig.getHBaseTableNamePrefix() : namespace + ":" + kylinConfig.getHBaseTableNamePrefix();
            HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
            ArrayList<String> allTablesNeedToBeDropped = new ArrayList<String>();
            for (HTableDescriptor desc : tableDescriptors) {
                String host = desc.getValue("KYLIN_HOST");
                if (!kylinConfig.getMetadataUrlPrefix().equalsIgnoreCase(host)) continue;
                allTablesNeedToBeDropped.add(desc.getTableName().getNameAsString());
            }
            for (CubeInstance cube : cubeMgr.listAllCubes()) {
                for (CubeSegment seg : cube.getSegments()) {
                    String tablename = seg.getStorageLocationIdentifier();
                    if (!allTablesNeedToBeDropped.contains(tablename)) continue;
                    allTablesNeedToBeDropped.remove(tablename);
                    logger.info("Exclude table " + tablename + " from drop list, as the table belongs to cube " + cube.getName() + " with status " + cube.getStatus());
                }
            }
            if (delete) {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                for (String htableName : allTablesNeedToBeDropped) {
                    FutureTask futureTask = new FutureTask(new DeleteHTableRunnable(hbaseAdmin, htableName));
                    executorService.execute(futureTask);
                    try {
                        futureTask.get(deleteTimeout, TimeUnit.MINUTES);
                    }
                    catch (TimeoutException e) {
                        logger.warn("It fails to delete htable " + htableName + ", for it cost more than " + deleteTimeout + " minutes!");
                        futureTask.cancel(true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        futureTask.cancel(true);
                    }
                }
                executorService.shutdown();
            } else {
                System.out.println("--------------- Tables To Be Dropped ---------------");
                for (String htableName : allTablesNeedToBeDropped) {
                    System.out.println(htableName);
                }
                System.out.println("----------------------------------------------------");
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }

    static class DeleteHTableRunnable
    implements Callable {
        HBaseAdmin hbaseAdmin;
        String htableName;

        DeleteHTableRunnable(HBaseAdmin hbaseAdmin, String htableName) {
            this.hbaseAdmin = hbaseAdmin;
            this.htableName = htableName;
        }

        public Object call() throws Exception {
            logger.info("Deleting HBase table " + this.htableName);
            if (this.hbaseAdmin.tableExists(this.htableName)) {
                if (this.hbaseAdmin.isTableEnabled(this.htableName)) {
                    this.hbaseAdmin.disableTable(this.htableName);
                }
                this.hbaseAdmin.deleteTable(this.htableName);
                logger.info("Deleted HBase table " + this.htableName);
            } else {
                logger.info("HBase table" + this.htableName + " does not exist");
            }
            return null;
        }
    }
}

