/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.model.ExternalFilterDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.ExternalFilterRequest;
import org.apache.kylin.rest.service.ExtFilterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/extFilter"})
public class ExternalFilterController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(ExternalFilterController.class);
    @Autowired
    @Qualifier(value="extFilterService")
    private ExtFilterService extFilterService;

    @RequestMapping(value={"/saveExtFilter"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> saveExternalFilter(@RequestBody ExternalFilterRequest request) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String filterProject = request.getProject();
        ExternalFilterDesc desc = (ExternalFilterDesc)JsonUtil.readValue((String)request.getExtFilter(), ExternalFilterDesc.class);
        desc.setUuid(UUID.randomUUID().toString());
        this.extFilterService.saveExternalFilter(desc);
        this.extFilterService.syncExtFilterToProject(new String[]{desc.getName()}, filterProject);
        result.put("success", "true");
        return result;
    }

    @RequestMapping(value={"/updateExtFilter"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> updateExternalFilter(@RequestBody ExternalFilterRequest request) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        ExternalFilterDesc desc = (ExternalFilterDesc)JsonUtil.readValue((String)request.getExtFilter(), ExternalFilterDesc.class);
        this.extFilterService.updateExternalFilter(desc);
        this.extFilterService.syncExtFilterToProject(new String[]{desc.getName()}, request.getProject());
        result.put("success", "true");
        return result;
    }

    @RequestMapping(value={"/{filter}/{project}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> removeFilter(@PathVariable String filter, @PathVariable String project) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        this.extFilterService.removeExtFilterFromProject(filter, project);
        this.extFilterService.removeExternalFilter(filter);
        result.put("success", "true");
        return result;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ExternalFilterDesc> getExternalFilters(@RequestParam(value="project", required=true) String project) throws IOException {
        ArrayList filterDescs = Lists.newArrayList();
        filterDescs.addAll(this.extFilterService.getProjectManager().listExternalFilterDescs(project).values());
        return filterDescs;
    }
}

