/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.rest.request.SQLRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    protected static final Logger logger = LoggerFactory.getLogger(QueryUtil.class);
    private static List<IQueryTransformer> queryTransformers;

    public static String massageSql(SQLRequest sqlRequest) {
        int offset;
        String sql = sqlRequest.getSql();
        sql = sql.trim();
        sql = sql.replace("\r", " ").replace("\n", System.getProperty("line.separator"));
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        int limit = sqlRequest.getLimit();
        if (limit > 0 && !sql.toLowerCase().contains("limit")) {
            sql = sql + "\nLIMIT " + limit;
        }
        if ((offset = sqlRequest.getOffset().intValue()) > 0 && !sql.toLowerCase().contains("offset")) {
            sql = sql + "\nOFFSET " + offset;
        }
        if (queryTransformers == null) {
            QueryUtil.initQueryTransformers();
        }
        for (IQueryTransformer t : queryTransformers) {
            sql = t.transform(sql);
        }
        return sql;
    }

    private static void initQueryTransformers() {
        String[] classes;
        ArrayList transformers = Lists.newArrayList();
        transformers.add(new DefaultQueryTransformer());
        for (String clz : classes = KylinConfig.getInstanceFromEnv().getQueryTransformers()) {
            try {
                IQueryTransformer t = (IQueryTransformer)ClassUtil.newInstance((String)clz);
                transformers.add(t);
            }
            catch (Exception e) {
                logger.error("Failed to init query transformer", (Throwable)e);
            }
        }
        queryTransformers = transformers;
    }

    public static String makeErrorMsgUserFriendly(Throwable e) {
        String msg = e.getMessage();
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!cause.getClass().getName().contains("ParseException")) continue;
            msg = cause.getMessage();
            break;
        }
        return QueryUtil.makeErrorMsgUserFriendly(msg);
    }

    public static String makeErrorMsgUserFriendly(String errorMsg) {
        try {
            errorMsg = errorMsg.replaceAll("\\s", " ");
            Pattern pattern = Pattern.compile("error while executing SQL \"(.*)\":(.*)");
            Matcher matcher = pattern.matcher(errorMsg);
            if (matcher.find()) {
                return matcher.group(2).trim() + "\n" + "while executing SQL: \"" + matcher.group(1).trim() + "\"";
            }
            return errorMsg;
        }
        catch (Exception e) {
            return errorMsg;
        }
    }

    private static class DefaultQueryTransformer
    implements IQueryTransformer {
        private static final String S0 = "\\s*";
        private static final String S1 = "\\s";
        private static final String SM = "\\s+";
        private static final Pattern PTN_GROUP_BY = Pattern.compile("\\sGROUP\\s+BY\\s", 2);
        private static final Pattern PTN_HAVING_COUNT_GREATER_THAN_ZERO = Pattern.compile("\\sHAVING\\s+[(]?\\s*COUNT\\s*[(]\\s*1\\s*[)]\\s*>\\s*0\\s*[)]?", 2);
        private static final Pattern PTN_SUM_1 = Pattern.compile("\\s*SUM\\s*[(]\\s*[1]\\s*[)]\\s*", 2);
        private static final Pattern PTN_NOT_EQ = Pattern.compile("\\s*!=\\s*", 2);
        private static final Pattern PTN_INTERVAL = Pattern.compile("interval\\s+(floor\\()([\\d\\.]+)(\\))\\s+(second|minute|hour|day|month|year)", 2);
        private static final Pattern PTN_HAVING_ESCAPE_FUNCTION = Pattern.compile("\\{fn(.*?)\\}", 2);

        private DefaultQueryTransformer() {
        }

        @Override
        public String transform(String sql) {
            Matcher m;
            while ((m = PTN_HAVING_ESCAPE_FUNCTION.matcher(sql)).find()) {
                sql = sql.substring(0, m.start()) + m.group(1) + sql.substring(m.end());
            }
            m = PTN_HAVING_COUNT_GREATER_THAN_ZERO.matcher(sql);
            if (m.find() && !PTN_GROUP_BY.matcher(sql).find()) {
                sql = sql.substring(0, m.start()) + " " + sql.substring(m.end());
            }
            while ((m = PTN_SUM_1.matcher(sql)).find()) {
                sql = sql.substring(0, m.start()) + " COUNT(1) " + sql.substring(m.end());
            }
            while ((m = PTN_NOT_EQ.matcher(sql)).find()) {
                sql = sql.substring(0, m.start()) + " <> " + sql.substring(m.end());
            }
            while ((m = PTN_INTERVAL.matcher(sql)).find()) {
                int value = (int)Math.floor(Double.valueOf(m.group(2)));
                sql = sql.substring(0, m.start(1)) + "'" + value + "'" + sql.substring(m.end(3));
            }
            return sql;
        }
    }

    public static interface IQueryTransformer {
        public String transform(String var1);
    }
}

