/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.badquery.BadQueryHistory;
import org.apache.kylin.rest.service.BasicService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="diagnosisService")
public class DiagnosisService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisService.class);

    private File getDumpDir() {
        return Files.createTempDir();
    }

    private String getDiagnosisPackageName(File destDir) {
        File[] files = destDir.listFiles();
        if (files == null) {
            throw new RuntimeException("Diagnosis package is not available in directory: " + destDir.getAbsolutePath());
        }
        for (File subDir : files) {
            if (!subDir.isDirectory()) continue;
            for (File file : subDir.listFiles()) {
                if (!file.getName().endsWith(".zip")) continue;
                return file.getAbsolutePath();
            }
        }
        throw new RuntimeException("Diagnosis package not found in directory: " + destDir.getAbsolutePath());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public BadQueryHistory getProjectBadQueryHistory(String project) throws IOException {
        return this.getBadQueryHistoryManager().getBadQueriesForProject(project);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String dumpProjectDiagnosisInfo(String project) throws IOException {
        File exportPath = this.getDumpDir();
        String[] args = new String[]{project, exportPath.getAbsolutePath()};
        this.runDiagnosisCLI(args);
        return this.getDiagnosisPackageName(exportPath);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public String dumpJobDiagnosisInfo(String jobId) throws IOException {
        File exportPath = this.getDumpDir();
        String[] args = new String[]{jobId, exportPath.getAbsolutePath()};
        this.runDiagnosisCLI(args);
        return this.getDiagnosisPackageName(exportPath);
    }

    private void runDiagnosisCLI(String[] args) throws IOException {
        File cwd = new File("");
        logger.info("Current path: " + cwd.getAbsolutePath());
        logger.info("DiagnosisInfoCLI args: " + Arrays.toString(args));
        File script = new File(KylinConfig.getKylinHome() + File.separator + "bin", "diag.sh");
        if (!script.exists()) {
            throw new RuntimeException("diag.sh not found at " + script.getAbsolutePath());
        }
        String diagCmd = script.getAbsolutePath() + " " + StringUtils.join((Object[])args, (String)" ");
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        Pair cmdOutput = executor.execute(diagCmd, new org.apache.kylin.common.util.Logger(){

            public void log(String message) {
                logger.info(message);
            }
        });
        if ((Integer)cmdOutput.getKey() != 0) {
            throw new RuntimeException("Failed to generate diagnosis package.");
        }
    }
}

