/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.request.MetricsRequest;
import org.apache.kylin.rest.request.UpdateConfigRequest;
import org.apache.kylin.rest.response.GeneralResponse;
import org.apache.kylin.rest.response.MetricsResponse;
import org.apache.kylin.rest.service.AdminService;
import org.apache.kylin.rest.service.CubeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin"})
public class AdminController
extends BasicController {
    @Autowired
    private AdminService adminService;
    @Autowired
    private CubeService cubeMgmtService;

    @RequestMapping(value={"/env"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralResponse getEnv() {
        String env = this.adminService.getEnv();
        GeneralResponse envRes = new GeneralResponse();
        envRes.put("env", env);
        return envRes;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralResponse getConfig() {
        String config = this.adminService.getConfigAsString();
        GeneralResponse configRes = new GeneralResponse();
        configRes.put("config", config);
        return configRes;
    }

    @RequestMapping(value={"/metrics/cubes"}, method={RequestMethod.GET})
    @ResponseBody
    public MetricsResponse cubeMetrics(MetricsRequest request) {
        return this.cubeMgmtService.calculateMetrics(request);
    }

    @RequestMapping(value={"/storage"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void cleanupStorage() {
        this.adminService.cleanupStorage();
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.PUT})
    public void updateKylinConfig(@RequestBody UpdateConfigRequest updateConfigRequest) {
        KylinConfig.getInstanceFromEnv().setProperty(updateConfigRequest.getKey(), updateConfigRequest.getValue());
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public void setCubeMgmtService(CubeService cubeMgmtService) {
        this.cubeMgmtService = cubeMgmtService;
    }
}

