/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.kylin.rest.aspect.WaitForSyncBeforeRPC;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.OptRecRequest;
import org.apache.kylin.rest.request.RecCountUpdateRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.OptRecDetailResponse;
import org.apache.kylin.rest.response.OptRecLayoutsResponse;
import org.apache.kylin.rest.service.ModelSmartService;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.service.ProjectSmartService;
import org.apache.kylin.rest.service.RawRecService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.View;

@Controller
@RequestMapping(value={"/api/recommendations"}, produces={"application/vnd.apache.kylin-v4+json"})
public class RecommendationController
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger((String)"smart");
    private static final String MODEL_ID = "modelId";
    private static final String REC_COUNT_ACTION = "action";
    @Autowired
    @Qualifier(value="optRecService")
    private OptRecService optRecService;
    @Autowired
    private RawRecService rawRecService;
    @Autowired
    private ProjectSmartService projectService;
    @Autowired
    private ModelSmartService modelSmartService;

    protected Logger getLogger() {
        return logger;
    }

    @Deprecated
    @PostMapping(value={"/{model:.+}"})
    public String approveOptimizeRecommendations(HttpServletRequest request) {
        request.setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)HttpStatus.PERMANENT_REDIRECT);
        return "redirect:/api/models/recommendations";
    }

    @ApiOperation(value="validateOptimizeRecommendations", tags={"AI"}, notes="Add URL: {model}")
    @PostMapping(value={"/{model:.+}/validation"})
    @ResponseBody
    public EnvelopeResponse<OptRecDetailResponse> validateOptimizeRecommendations(@PathVariable(value="model") String modelId, @RequestBody OptRecRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectNotSemiAuto(request.getProject());
        this.checkRequiredArg(MODEL_ID, modelId);
        OptRecDetailResponse optRecDetailResponse = this.optRecService.validateSelectedRecItems(request.getProject(), modelId, request.getRecItemsToAddLayout(), request.getRecItemsToRemoveLayout());
        return new EnvelopeResponse("000", (Object)optRecDetailResponse, "");
    }

    @ApiOperation(value="cleanOptimizeRecommendations", tags={"AI"}, notes="Add URL: {model}")
    @DeleteMapping(value={"/{model:.+}/all"})
    @ResponseBody
    public EnvelopeResponse<String> cleanOptimizeRecommendations(@PathVariable(value="model") String modelId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        this.optRecService.clean(project, modelId);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="removeOptimizeRecommendationsV2", tags={"AI"}, notes="Add URL: {model}")
    @DeleteMapping(value={"/{model:.+}"})
    @ResponseBody
    public EnvelopeResponse<String> deleteOptimizeRecommendationsV2(@PathVariable(value="model") String modelId, @RequestParam(value="project") String project, @RequestParam(value="recs_to_remove_layout", required=false) List<Integer> layoutsToRemove, @RequestParam(value="recs_to_add_layout", required=false) List<Integer> layoutsToAdd) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        OptRecRequest request = new OptRecRequest();
        request.setModelId(modelId);
        request.setProject(project);
        if (layoutsToRemove != null) {
            request.setRecItemsToRemoveLayout(layoutsToRemove);
        }
        if (layoutsToAdd != null) {
            request.setRecItemsToAddLayout(layoutsToAdd);
        }
        this.optRecService.discard(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getOptimizeRecommendations", tags={"AI"}, notes="Add URL: {model}")
    @GetMapping(value={"/{model:.+}"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OptRecLayoutsResponse> getOptimizeRecommendations(@PathVariable(value="model") String modelId, @RequestParam(value="project") String project, @RequestParam(value="type", required=false, defaultValue="") List<String> recTypeList, @RequestParam(value="reverse", required=false, defaultValue="false") Boolean desc, @RequestParam(value="key", required=false, defaultValue="") String key, @RequestParam(value="sort_by", required=false, defaultValue="") String sortBy, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        OptRecLayoutsResponse optRecLayoutsResponse = this.optRecService.getOptRecLayoutsResponse(project, modelId, recTypeList, key, desc.booleanValue(), sortBy, offset.intValue(), limit.intValue());
        return new EnvelopeResponse("000", (Object)optRecLayoutsResponse, "");
    }

    @ApiOperation(value="getOptimizeRecommendationDetail", tags={"AI"}, notes="Add URL: {model}")
    @GetMapping(value={"/{model:.+}/{item_id:.+}"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<OptRecDetailResponse> getOptimizeRecommendations(@PathVariable(value="model") String modelId, @PathVariable(value="item_id") Integer itemId, @RequestParam(value="project") String project, @RequestParam(value="is_add", defaultValue="true") boolean isAdd) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        return new EnvelopeResponse("000", (Object)this.optRecService.getSingleOptRecDetail(project, modelId, itemId.intValue(), isAdd), "");
    }

    @ApiOperation(value="refreshRecommendationCount", tags={"AI"}, notes="Add URL: {model}")
    @PutMapping(value={"/count"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<String> refreshRecommendationCount(@RequestBody RecCountUpdateRequest request) {
        String project = request.getProject();
        String modelId = request.getModelId();
        String action = request.getAction();
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.checkRequiredArg(MODEL_ID, modelId);
        this.checkRequiredArg(REC_COUNT_ACTION, action);
        this.optRecService.updateRecommendationCount(project, modelId);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="accelerate query history and select topn", tags={"AI"}, notes="Add URL: {model}")
    @PutMapping(value={"/acceleration"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<String> accelerate(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        this.projectService.accelerateImmediately(project);
        this.rawRecService.updateCostsAndTopNCandidates(project);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

