/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;

public class FilterJoinConditionMergeRule
extends RelOptRule {
    public static final FilterJoinConditionMergeRule INSTANCE = new FilterJoinConditionMergeRule(FilterJoinConditionMergeRule.operand(OlapFilterRel.class, (RelOptRuleOperand)FilterJoinConditionMergeRule.operand(OlapJoinRel.class, (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "FilterJoinConditionMergeRule");

    public FilterJoinConditionMergeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Join join = (Join)call.rel(1);
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        List originFilters = RelOptUtil.conjunctions((RexNode)filter.getCondition());
        int originFilterSize = originFilters.size();
        List<RexNode> inputFilters = originFilters.stream().map(arg_0 -> ((RexBuilder)rexBuilder).copy(arg_0)).collect(Collectors.toList());
        this.simplify(rexBuilder, originFilters, join, inputFilters);
        if (originFilters.size() == originFilterSize) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)join);
        relBuilder.filter((Iterable)originFilters);
        call.transformTo(relBuilder.build());
    }

    private void simplify(RexBuilder rexBuilder, List<RexNode> reservedJoinFilters, Join join, List<RexNode> filterConditions) {
        List joinFilters = RelOptUtil.conjunctions((RexNode)join.getCondition());
        if (filterConditions.isEmpty()) {
            return;
        }
        JoinRelType joinType = join.getJoinType();
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        List backup = joinFilters.stream().map(arg_0 -> ((RexBuilder)rexBuilder).copy(arg_0)).collect(Collectors.toList());
        boolean filterPushed = RelOptUtil.classifyFilters((RelNode)join, filterConditions, (boolean)true, (!joinType.generatesNullsOnLeft() ? 1 : 0) != 0, (!joinType.generatesNullsOnRight() ? 1 : 0) != 0, (List)joinFilters, leftFilters, rightFilters);
        if (filterPushed) {
            RelNode right;
            reservedJoinFilters.removeAll(backup);
            RelNode left = join.getLeft() instanceof HepRelVertex ? ((HepRelVertex)join.getLeft()).getCurrentRel() : join.getLeft();
            RelNode relNode = right = join.getRight() instanceof HepRelVertex ? ((HepRelVertex)join.getRight()).getCurrentRel() : join.getRight();
            if (left instanceof Join) {
                this.simplify(rexBuilder, reservedJoinFilters, (Join)left, leftFilters);
            }
            if (right instanceof Join) {
                this.simplify(rexBuilder, reservedJoinFilters, (Join)right, rightFilters);
            }
        }
    }
}

