/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.meta;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.engine.meta.MutableDataContext;

public class SimpleDataContext
implements MutableDataContext {
    private final SchemaPlus rootSchema;
    private final JavaTypeFactory javaTypeFactory;
    private final KylinConfig kylinConfig;
    private final Map<String, Object> contextVars = new HashMap<String, Object>();
    private boolean isContentQuery = false;

    public SimpleDataContext(SchemaPlus rootSchema, JavaTypeFactory javaTypeFactory, KylinConfig kylinConfig) {
        this.rootSchema = rootSchema;
        this.javaTypeFactory = javaTypeFactory;
        this.kylinConfig = kylinConfig;
        this.initContextVars();
    }

    private void initContextVars() {
        this.putContextVar(DataContext.Variable.TIME_ZONE.camelName, TimeZone.getTimeZone(this.kylinConfig.getTimeZone()));
    }

    public SchemaPlus getRootSchema() {
        return this.rootSchema;
    }

    public JavaTypeFactory getTypeFactory() {
        return this.javaTypeFactory;
    }

    public QueryProvider getQueryProvider() {
        return null;
    }

    public Object get(String name) {
        return this.contextVars.get(name);
    }

    @Override
    public void putContextVar(String name, Object value) {
        this.contextVars.put(name, value);
    }

    public void setPrepareParam(int idx, Object value) {
        this.contextVars.put(this.prepareParamName(idx), value);
    }

    private String prepareParamName(int idx) {
        return String.format(Locale.ROOT, "?%d", idx);
    }

    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    public boolean isContentQuery() {
        return this.isContentQuery;
    }

    public void setContentQuery(boolean contentQuery) {
        this.isContentQuery = contentQuery;
    }
}

