/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.source.adhocquery.IPushDownConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaConverter
implements IPushDownConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaConverter.class);

    public String convert(String originSql, String project, String defaultSchema) {
        KylinConfig config = NProjectManager.getProjectConfig((String)project);
        if (!config.isInternalTableEnabled()) {
            log.debug("PushdownToInternal is not enabled, skip it.");
            return originSql;
        }
        if (!QueryContext.current().getQueryTagInfo().isPushdown()) {
            log.debug("Pushdown tag is not found, skip it.");
            return originSql;
        }
        if (QueryContext.current().getQueryTagInfo().isAsyncQuery() && config.isUniqueAsyncQueryYarnQueue() && !config.uniqueAsyncQueryUseGlutenEnabled()) {
            log.debug("Async query, skip it");
            return originSql;
        }
        try {
            String transformedSql = this.transform(originSql, project, defaultSchema, config);
            QueryContext.current().setPushdownEngine("GLUTEN");
            return transformedSql;
        }
        catch (Exception e) {
            log.error("Convert failed! return origin SQL: {}", (Object)originSql, (Object)e);
            Thread.currentThread().interrupt();
            QueryContext.current().setPushdownEngine("GLUTEN");
            QueryContext.current().getQueryTagInfo().setErrInterrupted(true);
            QueryContext.current().getQueryTagInfo().setInterruptReason(e.getMessage());
            return originSql;
        }
    }

    public String transform(String originSql, String project, String defaultSchema, KylinConfig config) throws SqlParseException {
        SqlNode node = CalciteParser.parse((String)originSql, (String)project);
        TableNameVisitor visitor = new TableNameVisitor(originSql);
        node.accept((SqlVisitor)visitor);
        List<Pair<SqlIdentifier, Pair<Integer, Integer>>> tableNamesWithPos = visitor.getTableNamesWithPos();
        return this.replaceDbNameAndAddCatalog(tableNamesWithPos, originSql, defaultSchema, config, project);
    }

    private String replaceDbNameAndAddCatalog(List<Pair<SqlIdentifier, Pair<Integer, Integer>>> positions, String originSql, String defaultSchema, KylinConfig config, String project) {
        positions.sort((o1, o2) -> (Integer)((Pair)o2.getSecond()).getFirst() - (Integer)((Pair)o1.getSecond()).getFirst());
        String sql = originSql + " ";
        InternalTableManager manager = InternalTableManager.getInstance((KylinConfig)config, (String)project);
        ArrayList realizations = Lists.newArrayList();
        ArrayList tableIdentities = Lists.newArrayList();
        for (Pair<SqlIdentifier, Pair<Integer, Integer>> pos : positions) {
            InternalTableDesc table;
            SqlIdentifier identifier = (SqlIdentifier)pos.getFirst();
            String tableIdentity = identifier.toString();
            if (identifier.names.size() == 1) {
                tableIdentity = defaultSchema + '.' + tableIdentity;
            }
            if (!config.getSourceNameCaseSensitiveEnabled()) {
                tableIdentity = tableIdentity.toUpperCase(Locale.ROOT);
            }
            if ((table = manager.getInternalTableDesc(tableIdentity)) == null) {
                throw new IllegalStateException("Table " + tableIdentity + " is not an internal table.");
            }
            sql = sql.substring(0, (Integer)((Pair)pos.getSecond()).getFirst()) + table.getDoubleQuoteInternalIdentity() + sql.substring((Integer)((Pair)pos.getSecond()).getSecond());
            tableIdentities.add(tableIdentity);
        }
        NativeQueryRealization lookupRealization = new NativeQueryRealization(null, null, "Internal Table", (List)tableIdentities);
        realizations.add(lookupRealization);
        QueryContext.current().setQueryRealizations((List)realizations);
        return sql.trim();
    }

    static class TableNameVisitor
    extends SqlBasicVisitor<SqlNode> {
        private final List<Pair<SqlIdentifier, Pair<Integer, Integer>>> tableNamesWithPos = new ArrayList<Pair<SqlIdentifier, Pair<Integer, Integer>>>();
        private final String originSql;
        private final Set<String> namesOfWithItems = new HashSet<String>();

        public TableNameVisitor(String originSql) {
            this.originSql = originSql;
        }

        public SqlNode visit(SqlCall call) {
            if (call.getKind() == SqlKind.SELECT) {
                SqlNode from = ((SqlSelect)call).getFrom();
                this.checkIdentifier(from);
            } else if (call.getKind() == SqlKind.JOIN) {
                SqlJoin join = (SqlJoin)call;
                this.checkIdentifier(join.getLeft());
                this.checkIdentifier(join.getRight());
            } else if (call.getKind() == SqlKind.WITH) {
                SqlWith sqlWith = (SqlWith)call;
                for (SqlNode withNode : sqlWith.withList) {
                    this.visitWith(withNode);
                }
                sqlWith.body.accept((SqlVisitor)this);
                return null;
            }
            return (SqlNode)super.visit(call);
        }

        private void visitWith(SqlNode withNode) {
            if (withNode instanceof SqlWithItem) {
                SqlWithItem withItem = (SqlWithItem)withNode;
                withItem.query.accept((SqlVisitor)this);
                this.namesOfWithItems.add(withItem.name.toString());
            } else if (withNode instanceof SqlCall) {
                withNode.accept((SqlVisitor)this);
            }
        }

        private void checkIdentifier(SqlNode node) {
            if (node instanceof SqlBasicCall && node.getKind() == SqlKind.AS) {
                node = ((SqlBasicCall)node).operand(0);
            }
            if (node instanceof SqlIdentifier) {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)node;
                if (sqlIdentifier.names.size() == 2 || sqlIdentifier.names.size() == 1 && !this.namesOfWithItems.contains(sqlIdentifier.names.get(0))) {
                    this.tableIdentifierFound((SqlIdentifier)node);
                }
            }
        }

        public void tableIdentifierFound(SqlIdentifier node) {
            Pair pos = CalciteParser.getReplacePos((SqlNode)node, (String)this.originSql);
            this.tableNamesWithPos.add((Pair<SqlIdentifier, Pair<Integer, Integer>>)new Pair((Object)node, (Object)pos));
        }

        @Generated
        public List<Pair<SqlIdentifier, Pair<Integer, Integer>>> getTableNamesWithPos() {
            return this.tableNamesWithPos;
        }
    }
}

