/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.CollectionUtil;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.measure.topn.TopNMeasureType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.QueryExtension;
import org.apache.kylin.query.enumerator.OlapQuery;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.schema.KylinRelDataTypeFactoryImpl;
import org.apache.kylin.query.schema.KylinRelDataTypeFieldImpl;
import org.apache.kylin.query.schema.OlapSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapTable
extends AbstractQueryableTable
implements TranslatableTable {
    protected static final Logger logger = LoggerFactory.getLogger(OlapTable.class);
    private static final Map<String, SqlTypeName> SQLTYPE_MAPPING = new HashMap<String, SqlTypeName>();
    private static final Map<String, SqlTypeName> REGEX_SQLTYPE_MAPPING = new HashMap<String, SqlTypeName>();
    private final OlapSchema olapSchema;
    private final TableDesc sourceTable;
    protected RelDataType rowType;
    private List<ColumnDesc> sourceColumns;
    private Map<String, List<NDataModel>> modelsMap;

    public OlapTable(OlapSchema schema, TableDesc tableDesc, Map<String, List<NDataModel>> modelsMap) {
        super(Object[].class);
        this.olapSchema = schema;
        this.sourceTable = tableDesc;
        this.rowType = null;
        this.modelsMap = modelsMap;
    }

    public static RelDataType createSqlType(RelDataTypeFactory typeFactory, DataType dataType, boolean isNullable) {
        RelDataType result;
        SqlTypeName sqlTypeName = SQLTYPE_MAPPING.get(dataType.getName());
        if (sqlTypeName == null) {
            for (Map.Entry<String, SqlTypeName> entry : REGEX_SQLTYPE_MAPPING.entrySet()) {
                String reg = entry.getKey();
                Pattern pattern = Pattern.compile(reg);
                if (!pattern.matcher(dataType.getName()).matches()) continue;
                sqlTypeName = REGEX_SQLTYPE_MAPPING.get(reg);
                break;
            }
        }
        if (sqlTypeName == null) {
            throw new IllegalArgumentException("Unrecognized data type " + dataType);
        }
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (sqlTypeName == SqlTypeName.ARRAY) {
            String innerTypeName = StringUtils.split((String)dataType.getName(), (String)"<|>")[1];
            result = typeFactory.createArrayType(OlapTable.createSqlType(typeFactory, DataType.getType((String)innerTypeName), false), -1L);
        } else {
            result = precision >= 0 && scale >= 0 ? typeFactory.createSqlType(sqlTypeName, precision, scale) : (precision >= 0 ? typeFactory.createSqlType(sqlTypeName, precision) : typeFactory.createSqlType(sqlTypeName));
        }
        result = isNullable ? typeFactory.createTypeWithNullability(result, true) : typeFactory.createTypeWithNullability(result, false);
        return result;
    }

    public OlapSchema getSchema() {
        return this.olapSchema;
    }

    public TableDesc getSourceTable() {
        return this.sourceTable;
    }

    public String getTableName() {
        return this.sourceTable.getIdentity();
    }

    public List<ColumnDesc> getSourceColumns() {
        if (this.sourceColumns == null) {
            this.sourceColumns = this.listSourceColumns();
        }
        return this.sourceColumns;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType == null) {
            this.sourceColumns = this.getSourceColumns();
            this.rowType = this.deriveRowType(typeFactory);
        }
        return this.rowType;
    }

    private RelDataType deriveRowType(RelDataTypeFactory typeFactory) {
        KylinRelDataTypeFactoryImpl kylinRelDataTypeFactory = new KylinRelDataTypeFactoryImpl(typeFactory);
        ArrayList fieldNameList = Lists.newArrayList();
        ArrayList typeList = Lists.newArrayList();
        ArrayList colTypes = Lists.newArrayList();
        KylinConfig config = this.sourceTable != null ? NProjectManager.getProjectConfig((String)this.sourceTable.getProject()) : KylinConfig.getInstanceFromEnv();
        for (ColumnDesc column : this.sourceColumns) {
            String columnName;
            RelDataType sqlType = OlapTable.createSqlType((RelDataTypeFactory)kylinRelDataTypeFactory, column.getUpgradedType(), column.isNullable());
            sqlType = SqlTypeUtil.addCharsetAndCollation((RelDataType)sqlType, (RelDataTypeFactory)kylinRelDataTypeFactory);
            typeList.add(sqlType);
            String string = columnName = config.getSourceNameCaseSensitiveEnabled() && StringUtils.isNotBlank((CharSequence)column.getCaseSensitiveName()) ? column.getCaseSensitiveName() : column.getName();
            if (column.isComputedColumn()) {
                fieldNameList.add(columnName);
                colTypes.add(KylinRelDataTypeFieldImpl.ColumnType.CC_FIELD);
                continue;
            }
            fieldNameList.add(columnName);
            colTypes.add(KylinRelDataTypeFieldImpl.ColumnType.ORIGIN_FILED);
        }
        return kylinRelDataTypeFactory.createStructType(StructKind.FULLY_QUALIFIED, typeList, fieldNameList, colTypes);
    }

    private List<ColumnDesc> listSourceColumns() {
        NProjectManager mgr = NProjectManager.getInstance((KylinConfig)this.olapSchema.getConfig());
        List<ColumnDesc> tableColumns = this.listTableColumnsIncludingCC();
        ArrayList metricColumns = Lists.newArrayList();
        List countMeasures = mgr.listEffectiveRewriteMeasures(this.olapSchema.getProject(), this.sourceTable.getIdentity());
        HashSet<String> metFields = new HashSet<String>();
        for (MeasureDesc m : countMeasures) {
            FunctionDesc func = m.getFunction();
            String fieldName = "TOP_N".equalsIgnoreCase(func.getExpression()) ? TopNMeasureType.getRewriteName((FunctionDesc)func) : func.getRewriteFieldName();
            if (metFields.contains(fieldName)) continue;
            metFields.add(fieldName);
            ColumnDesc fakeCountCol = func.newFakeRewriteColumn(fieldName, this.sourceTable);
            metricColumns.add(fakeCountCol);
        }
        tableColumns.sort(Comparator.comparingInt(ColumnDesc::getZeroBasedIndex));
        return Lists.newArrayList((Iterable)Iterables.concat(tableColumns, (Iterable)metricColumns));
    }

    private List<ColumnDesc> listTableColumnsIncludingCC() {
        ArrayList allColumns = Lists.newArrayList((Object[])this.sourceTable.getColumns());
        if (!this.modelsMap.containsKey(this.sourceTable.getIdentity())) {
            return allColumns;
        }
        List<ComputedColumnDesc> authorizedCC = this.getAuthorizedCC();
        if (CollectionUtils.isNotEmpty(authorizedCC)) {
            Object[] ccAsColumnDesc = ComputedColumnUtil.createComputedColumns(authorizedCC, (TableDesc)this.sourceTable);
            allColumns.addAll(Lists.newArrayList((Object[])ccAsColumnDesc));
        }
        return allColumns.stream().distinct().collect(Collectors.toList());
    }

    private List<ComputedColumnDesc> removeDuplicatedNamedComputedCols(List<ComputedColumnDesc> computedColumnDescs) {
        CollectionUtil.distinct(computedColumnDescs, cc -> cc.getIdentName().toUpperCase(Locale.ROOT));
        return computedColumnDescs;
    }

    private List<ComputedColumnDesc> getAuthorizedCC() {
        if (this.isACLDisabledOrAdmin()) {
            return this.removeDuplicatedNamedComputedCols(this.modelsMap.get(this.sourceTable.getIdentity()).stream().map(NDataModel::getComputedColumnDescs).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        List authorizedCC = ComputedColumnUtil.getAuthorizedCC(this.modelsMap.get(this.sourceTable.getIdentity()), this::isColumnAuthorized);
        return this.removeDuplicatedNamedComputedCols(authorizedCC);
    }

    private boolean isACLDisabledOrAdmin() {
        QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
        return !this.olapSchema.getConfig().isAclTCREnabled() || Objects.nonNull(aclInfo) && CollectionUtils.isNotEmpty((Collection)aclInfo.getGroups()) && aclInfo.getGroups().stream().anyMatch("ROLE_ADMIN"::equals) || Objects.nonNull(aclInfo) && aclInfo.isHasAdminPermission();
    }

    private boolean isColumnAuthorized(Set<String> ccSourceCols) {
        QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
        String userName = Objects.nonNull(aclInfo) ? aclInfo.getUsername() : null;
        Set groups = Objects.nonNull(aclInfo) ? aclInfo.getGroups() : null;
        return QueryExtension.getFactory().getTableColumnAuthExtension().isColumnsAuthorized(this.olapSchema.getConfig(), this.olapSchema.getProject(), userName, groups, ccSourceCols);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = this.identityList(fieldCount);
        return new OlapTableScan(context.getCluster(), relOptTable, this, fields);
    }

    protected int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, (QueryableTable)this, tableName){

            public Enumerator<T> enumerator() {
                OlapQuery query = new OlapQuery(OlapQuery.EnumeratorTypeEnum.OLAP, 0);
                return query.enumerator();
            }
        };
    }

    public Statistic getStatistic() {
        ArrayList keys = new ArrayList();
        return Statistics.of((double)100.0, keys);
    }

    public String toString() {
        return "OlapTable {" + this.getTableName() + "}";
    }

    public Enumerable<Object[]> executeOlapQuery(DataContext optiqContext, int ctxSeq) {
        return new OlapQuery(optiqContext, OlapQuery.EnumeratorTypeEnum.OLAP, ctxSeq);
    }

    public Enumerable<Object[]> executeHiveQuery(DataContext optiqContext, int ctxSeq) {
        return new OlapQuery(optiqContext, OlapQuery.EnumeratorTypeEnum.HIVE, ctxSeq);
    }

    public Enumerable<Object[]> executeSimpleAggregationQuery(DataContext optiqContext, int ctxSeq) {
        return new OlapQuery(optiqContext, OlapQuery.EnumeratorTypeEnum.SIMPLE_AGGREGATION, ctxSeq);
    }

    public Enumerable<Object[]> executeMetadataQuery(DataContext optiqContext, int ctxSeq) {
        return new OlapQuery(optiqContext, OlapQuery.EnumeratorTypeEnum.METADATA, ctxSeq);
    }

    static {
        SQLTYPE_MAPPING.put("char", SqlTypeName.CHAR);
        SQLTYPE_MAPPING.put("varchar", SqlTypeName.VARCHAR);
        SQLTYPE_MAPPING.put("boolean", SqlTypeName.BOOLEAN);
        SQLTYPE_MAPPING.put("integer", SqlTypeName.INTEGER);
        SQLTYPE_MAPPING.put("tinyint", SqlTypeName.TINYINT);
        SQLTYPE_MAPPING.put("smallint", SqlTypeName.SMALLINT);
        SQLTYPE_MAPPING.put("bigint", SqlTypeName.BIGINT);
        SQLTYPE_MAPPING.put("decimal", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("numeric", SqlTypeName.DECIMAL);
        SQLTYPE_MAPPING.put("float", SqlTypeName.FLOAT);
        SQLTYPE_MAPPING.put("real", SqlTypeName.REAL);
        SQLTYPE_MAPPING.put("double", SqlTypeName.DOUBLE);
        SQLTYPE_MAPPING.put("date", SqlTypeName.DATE);
        SQLTYPE_MAPPING.put("time", SqlTypeName.TIME);
        SQLTYPE_MAPPING.put("timestamp", SqlTypeName.TIMESTAMP);
        SQLTYPE_MAPPING.put("any", SqlTypeName.ANY);
        REGEX_SQLTYPE_MAPPING.put("array\\<.*\\>", SqlTypeName.ARRAY);
    }
}

