/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableNestedLoopJoin;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexToTblColRefTranslator;
import org.apache.kylin.query.util.RexUtils;

public class OlapNonEquiJoinRel
extends EnumerableNestedLoopJoin
implements OlapRel {
    private ColumnRowType columnRowType;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private boolean isPreCalJoin = true;
    private boolean aboveContextPreCalcJoin = false;
    private int leftInputSizeBeforeRewrite = -1;
    private final boolean isScd2Rel;

    public OlapNonEquiJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean isScd2Rel) throws InvalidRelException {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
        this.leftInputSizeBeforeRewrite = left.getRowType().getFieldList().size();
        this.rowType = this.getRowType();
        this.isScd2Rel = isScd2Rel;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        OlapRel.ContextVisitorState leftState = OlapRel.ContextVisitorState.init();
        contextImpl.fixSharedOlapTableScanOnTheLeft((BiRel)this);
        contextImpl.visitChild(this.getInput(0), this, leftState);
        OlapRel.ContextVisitorState rightState = OlapRel.ContextVisitorState.init();
        contextImpl.fixSharedOlapTableScanOnTheRight((BiRel)this);
        contextImpl.visitChild(this.getInput(1), this, rightState);
        this.allocateContext(leftState, rightState, contextImpl);
        state.merge(leftState).merge(rightState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.left));
        this.subContexts.addAll(ContextUtil.collectSubContext(this.right));
    }

    private void allocateContext(OlapRel.ContextVisitorState leftState, OlapRel.ContextVisitorState rightState, OlapRel.ContextImpl contextImpl) {
        if (!this.isScd2Rel) {
            if (leftState.hasFreeTable()) {
                contextImpl.allocateContext((OlapRel)this.left, this);
                leftState.setHasFreeTable(false);
            }
            if (rightState.hasFreeTable()) {
                contextImpl.allocateContext((OlapRel)this.right, this);
                rightState.setHasFreeTable(false);
            }
            return;
        }
        if (rightState.hasFreeTable() && rightState.hasFilter()) {
            contextImpl.allocateContext((OlapRel)this.right, this);
            rightState.setHasFreeTable(false);
        }
        if (!leftState.hasFreeTable() && !rightState.hasFreeTable()) {
            return;
        }
        if (leftState.hasFreeTable() && !rightState.hasFreeTable()) {
            contextImpl.allocateContext((OlapRel)this.left, this);
            leftState.setHasFreeTable(false);
        } else if (rightState.hasFreeTable() && !leftState.hasFreeTable()) {
            contextImpl.allocateContext((OlapRel)this.right, this);
            rightState.setHasFreeTable(false);
        } else if (rightState.hasIncrementalTable() || this.hasSameFirstTable(leftState, rightState) || RexUtils.joinMoreThanOneTable((Join)this)) {
            contextImpl.allocateContext((OlapRel)this.left, this);
            contextImpl.allocateContext((OlapRel)this.right, this);
            leftState.setHasFreeTable(false);
            rightState.setHasFreeTable(false);
        }
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        if (this.isPreCalJoin) {
            this.context = null;
            this.columnRowType = null;
            contextCutImpl.allocateContext((OlapRel)this.getInput(0), this);
            contextCutImpl.allocateContext((OlapRel)this.getInput(1), this);
        } else {
            RelNode input = ((OlapRel)this.left).getContext() == null ? this.left : this.right;
            contextCutImpl.visitChild(input);
            this.context = null;
            this.columnRowType = null;
        }
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        if (this.context != null) {
            this.aboveContextPreCalcJoin = !this.isPreCalJoin || !this.context.isHasPreCalcJoin();
            this.context.setHasJoin(true);
            this.context.setHasPreCalcJoin(this.context.isHasPreCalcJoin() || this.isPreCalJoin);
        }
        olapImpl.visitChild(this.left, this);
        olapImpl.visitChild(this.right, this);
        this.columnRowType = this.buildColumnRowType();
        Set<TblColRef> joinCols = this.collectColumnsInJoinCondition(this.getCondition());
        if (this.context != null) {
            if (this.isPreCalJoin) {
                this.buildAndUpdateContextJoin(this.condition);
            } else {
                for (TblColRef joinCol : joinCols) {
                    if (!this.context.belongToContextTables(joinCol)) continue;
                    this.context.getSubqueryJoinParticipants().add(joinCol);
                    this.context.getAllColumns().add(joinCol);
                }
                this.pushDownJoinColsToSubContexts(joinCols);
            }
        } else {
            this.pushDownJoinColsToSubContexts(joinCols);
        }
    }

    private void buildAndUpdateContextJoin(RexNode condition) {
        condition = this.preTransferCastColumn(condition);
        JoinDesc.JoinDescBuilder joinDescBuilder = new JoinDesc.JoinDescBuilder();
        JoinInfo joinInfo = JoinInfo.of((RelNode)this.left, (RelNode)this.right, (RexNode)condition);
        HashSet leftCols = new HashSet();
        joinInfo.leftKeys.forEach(key -> leftCols.addAll(this.getColFromLeft((int)key).getSourceColumns()));
        joinDescBuilder.addForeignKeys(leftCols);
        HashSet rightCols = new HashSet();
        joinInfo.rightKeys.forEach(key -> rightCols.addAll(this.getColFromRight((int)key).getSourceColumns()));
        joinDescBuilder.addPrimaryKeys(rightCols);
        String joinType = this.getJoinType() == JoinRelType.INNER || this.getJoinType() == JoinRelType.LEFT ? this.getJoinType().name() : null;
        joinDescBuilder.setType(joinType);
        RexNode neqCond = RexUtil.composeConjunction((RexBuilder)new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT)), (Iterable)joinInfo.nonEquiConditions);
        if (CollectionUtils.isNotEmpty(leftCols) && CollectionUtils.isNotEmpty(rightCols)) {
            joinDescBuilder.setForeignTableRef(((TblColRef)leftCols.iterator().next()).getTableRef());
            joinDescBuilder.setPrimaryTableRef(((TblColRef)rightCols.iterator().next()).getTableRef());
        } else {
            joinDescBuilder.setForeignTableRef(((OlapRel)this.left).getColumnRowType().getColumnByIndex(0).getTableRef());
            joinDescBuilder.setPrimaryTableRef(((OlapRel)this.right).getColumnRowType().getColumnByIndex(0).getTableRef());
        }
        NonEquiJoinCondition nonEquiJoinCondition = this.doBuildJoin(neqCond);
        nonEquiJoinCondition.setExpr(RexToTblColRefTranslator.translateRexNode(condition, this.columnRowType).getParserDescription());
        joinDescBuilder.setNonEquiJoinCondition(nonEquiJoinCondition);
        JoinDesc joinDesc = joinDescBuilder.build();
        this.context.getJoins().add(joinDesc);
    }

    private RexNode preTransferCastColumn(RexNode condition) {
        if (condition instanceof RexCall) {
            RexCall conditionCall = (RexCall)condition;
            List rexNodes = conditionCall.getOperands().stream().map(RexUtils::stripOffCastInColumnEqualPredicate).collect(Collectors.toList());
            return conditionCall.clone(conditionCall.getType(), rexNodes);
        }
        return condition;
    }

    private NonEquiJoinCondition doBuildJoin(RexNode condition) {
        if (condition instanceof RexCall) {
            LinkedList<NonEquiJoinCondition> nonEquiJoinConditions = new LinkedList<NonEquiJoinCondition>();
            for (RexNode operand : ((RexCall)condition).getOperands()) {
                nonEquiJoinConditions.add(this.doBuildJoin(operand));
            }
            return new NonEquiJoinCondition(((RexCall)condition).getOperator(), nonEquiJoinConditions.toArray(new NonEquiJoinCondition[0]), condition.getType());
        }
        if (condition instanceof RexInputRef) {
            int colIdx = ((RexInputRef)condition).getIndex();
            Set sourceCols = this.getColByIndex(colIdx).getSourceColumns();
            Preconditions.checkArgument((sourceCols.size() == 1 ? 1 : 0) != 0);
            TblColRef sourceCol = (TblColRef)sourceCols.iterator().next();
            return new NonEquiJoinCondition(sourceCol, condition.getType());
        }
        if (condition instanceof RexLiteral) {
            return new NonEquiJoinCondition((RexLiteral)condition, condition.getType());
        }
        throw new IllegalStateException("Invalid join condition " + condition);
    }

    private TblColRef getColByIndex(int idx) {
        int leftColumnsSize = ((OlapRel)this.left).getColumnRowType().getAllColumns().size();
        if (idx < leftColumnsSize) {
            return this.getColFromLeft(idx);
        }
        return this.getColFromRight(idx - leftColumnsSize);
    }

    private TblColRef getColFromLeft(int idx) {
        return ((OlapRel)this.left).getColumnRowType().getAllColumns().get(idx);
    }

    private TblColRef getColFromRight(int idx) {
        return ((OlapRel)this.right).getColumnRowType().getAllColumns().get(idx);
    }

    private void pushDownJoinColsToSubContexts(Set<TblColRef> joinColumns) {
        for (OlapContext subContext : this.subContexts) {
            for (TblColRef joinCol : joinColumns) {
                if (!subContext.belongToContextTables(joinCol)) continue;
                subContext.getAllColumns().add(joinCol);
            }
        }
    }

    private Set<TblColRef> collectColumnsInJoinCondition(RexNode condition) {
        return RexUtils.getAllInputRefs(condition).stream().map(inRef -> this.columnRowType.getColumnByIndex(inRef.getIndex())).flatMap(col -> col.getSourceColumns().stream()).collect(Collectors.toSet());
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        OlapRel leftRel = (OlapRel)this.left;
        OlapRel rightRel = (OlapRel)this.right;
        ColumnRowType leftColumnRowType = leftRel.getColumnRowType();
        ColumnRowType rightColumnRowType = rightRel.getColumnRowType();
        columns.addAll(leftColumnRowType.getAllColumns());
        columns.addAll(rightColumnRowType.getAllColumns());
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        rewriteImpl.visitChild(this, this.left);
        rewriteImpl.visitChild(this, this.right);
        if (this.context != null) {
            this.rowType = this.deriveRowType();
            if (this.context.hasPrecalculatedFields() && OlapRel.RewriteImpl.needRewrite(this.context) && this.aboveContextPreCalcJoin) {
                int paramIndex = this.rowType.getFieldList().size();
                LinkedList newFieldList = Lists.newLinkedList();
                for (Map.Entry<String, RelDataType> rewriteField : this.context.getRewriteFields().entrySet()) {
                    String fieldName = rewriteField.getKey();
                    if (this.rowType.getField(fieldName, true, false) != null) continue;
                    RelDataType fieldType = rewriteField.getValue();
                    RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(fieldName, paramIndex++, fieldType);
                    newFieldList.add(newField);
                }
                List fieldList = Stream.of(this.rowType.getFieldList(), newFieldList).flatMap(Collection::stream).collect(Collectors.toList());
                this.rowType = this.getCluster().getTypeFactory().createStructType(fieldList);
                this.columnRowType = this.rebuildColumnRowType(newFieldList);
            }
        }
    }

    private ColumnRowType rebuildColumnRowType(List<RelDataTypeField> missingFields) {
        ArrayList columns = Lists.newArrayList();
        OlapRel olapLeft = (OlapRel)this.left;
        OlapRel olapRight = (OlapRel)this.right;
        columns.addAll(olapLeft.getColumnRowType().getAllColumns());
        columns.addAll(olapRight.getColumnRowType().getAllColumns());
        for (RelDataTypeField dataTypeField : missingFields) {
            String fieldName = dataTypeField.getName();
            TblColRef aggOutCol = TblColRef.newInnerColumn((String)fieldName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL);
            aggOutCol.getColumnDesc().setId(String.valueOf(dataTypeField.getIndex()));
            columns.add(aggOutCol);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return super.copy(this.traitSet, this.condition, (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.joinType, this.isSemiJoinDone());
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context != null) {
            return false;
        }
        if (this == context.getParentOfTopNode() || ((OlapRel)this.getLeft()).pushRelInfoToContext(context) || ((OlapRel)this.getRight()).pushRelInfoToContext(context)) {
            this.context = context;
            this.isPreCalJoin = false;
            return true;
        }
        return false;
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        for (RelNode input : this.getInputs()) {
            ((OlapRel)input).setContext(context);
            this.subContexts.addAll(ContextUtil.collectSubContext(input));
        }
    }

    @Override
    public boolean hasSubQuery() {
        throw new UnsupportedOperationException("hasSubQuery is not implemented yet");
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.joinType == JoinRelType.RIGHT ? super.computeSelfCost(planner, mq).multiplyBy(100.0) : super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public EnumerableNestedLoopJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new OlapNonEquiJoinRel(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType, this.isScd2Rel);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) * 0.1;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context));
    }

    public boolean isRuntimeJoin() {
        if (this.context != null) {
            this.context.setReturnTupleInfo(this.rowType, this.columnRowType);
        }
        return this.context == null || ((OlapRel)this.left).getContext() != ((OlapRel)this.right).getContext();
    }

    private boolean hasSameFirstTable(OlapRel.ContextVisitorState leftState, OlapRel.ContextVisitorState rightState) {
        return !leftState.hasIncrementalTable() && !rightState.hasIncrementalTable() && leftState.hasFirstTable() && rightState.hasFirstTable();
    }

    public int getLeftInputSizeBeforeRewrite() {
        return this.leftInputSizeBeforeRewrite;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    public boolean isScd2Rel() {
        return this.isScd2Rel;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }

    @Generated
    private boolean isPreCalJoin() {
        return this.isPreCalJoin;
    }

    @Generated
    private boolean isAboveContextPreCalcJoin() {
        return this.aboveContextPreCalcJoin;
    }
}

