/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.SparkDDLController;
import org.apache.kylin.rest.request.OpenLogicalViewRequest;
import org.apache.kylin.rest.request.ViewRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logical_view"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenLogicalViewController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenLogicalViewController.class);
    @Autowired
    private SparkDDLController sparkDDLController;

    @ApiOperation(value="ddl", tags={"LogicalView"}, notes="create/replace/drop logical view")
    @PostMapping(value={"/ddl"})
    @ResponseBody
    public EnvelopeResponse<String> executeSql(@RequestBody OpenLogicalViewRequest request) {
        String project = this.checkProjectName(request.getProject());
        this.checkRequiredArg("sql", request.getSql());
        if (!"logic".equals(request.getRestrict()) && !"replaceLogicalView".equals(request.getRestrict())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"restrict", "logic, replaceLogicalView"});
        }
        ViewRequest viewRequest = new ViewRequest(project, request.getSql(), request.getRestrict());
        return this.sparkDDLController.executeSQL(viewRequest);
    }
}

