/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinJdbcFactory;
import org.apache.kylin.jdbc.KylinMeta;
import org.apache.kylin.jdbc.LogInitializer;
import org.apache.kylin.jdbc.LoggerUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.DriverVersion;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
extends UnregisteredDriver {
    private static final Logger logger = LoggerFactory.getLogger(Driver.class);
    public static final String CONNECT_STRING_PREFIX = "jdbc:kylin:";
    public static final String PARAM_SPLIT_REGEX = ";";

    private static InputStream preprocessPropertiesFile(String myFile) throws IOException {
        try (Scanner in = new Scanner(new FileReader(myFile));){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (in.hasNext()) {
                out.write(in.nextLine().replace("\\", "\\\\").getBytes(Charset.defaultCharset()));
                out.write("\n".getBytes(Charset.defaultCharset()));
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
    }

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String prefix = this.getConnectStringPrefix();
        if (!url.startsWith(prefix)) {
            throw new AssertionError();
        }
        Properties info2 = this.connectStringParseProperties(url, info);
        AvaticaConnection connection = this.factory.newConnection(this, this.factory, url, info2);
        this.handler.onConnectionInit(connection);
        return connection;
    }

    private Properties connectStringParseProperties(String url, Properties props) {
        Properties newProps = props == null ? new Properties() : (Properties)props.clone();
        String prefixParams = url.split("//")[0].substring(this.getConnectStringPrefix().length());
        this.propertyParser(prefixParams, newProps);
        URI uri = URI.create(url.substring(CONNECT_STRING_PREFIX.length()));
        String propString = uri.getRawQuery();
        this.propertyParser(propString, newProps);
        return newProps;
    }

    private void propertyParser(String propString, Properties props) {
        if (propString == null) {
            return;
        }
        for (String propPair : propString.split(PARAM_SPLIT_REGEX)) {
            if (!propPair.contains("=")) continue;
            String[] splitted = propPair.split("=");
            String key = this.urlDecoder(splitted[0]);
            String val = "";
            if (splitted.length > 2) {
                IllegalArgumentException e = new IllegalArgumentException(String.format(Locale.ROOT, "The paramter in connection string '%s' is in wrong format. Please correct it and retry.", propPair));
                logger.error(e.getMessage());
                throw e;
            }
            if (splitted.length == 2) {
                val = this.urlDecoder(splitted[1]);
            }
            props.put(key, val);
        }
    }

    private String urlDecoder(String url) {
        try {
            url = URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Url decode fail: ", e);
        }
        return url;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-kylin-jdbc.properties", "Kylin JDBC Driver", "unknown version", "Kylin", "unknown version");
    }

    @Override
    protected String getFactoryClassName(UnregisteredDriver.JdbcVersion jdbcVersion) {
        switch (jdbcVersion) {
            case JDBC_30: {
                throw new UnsupportedOperationException();
            }
            case JDBC_40: {
                return KylinJdbcFactory.Version40.class.getName();
            }
        }
        return KylinJdbcFactory.Version41.class.getName();
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        LoggerUtils.entry(logger);
        KylinMeta meta = new KylinMeta((KylinConnection)connection);
        LoggerUtils.exit(logger);
        return meta;
    }

    static {
        LogInitializer.init();
        LoggerUtils.entry(logger);
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occurred while registering JDBC driver " + Driver.class.getName() + ": " + e);
        }
        LoggerUtils.exit(logger);
    }
}

