/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.DateTimeUtils;

public class KylinDateAccessor
extends AbstractCursor.AccessorImpl {
    public KylinDateAccessor(AbstractCursor.Getter getter) {
        super(getter);
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        Date date = (Date)this.getObject();
        if (date == null) {
            return null;
        }
        if (calendar != null) {
            long v = date.getTime();
            v -= (long)calendar.getTimeZone().getOffset(v);
            date = new Date(v);
        }
        return date;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        Date date = this.getDate(calendar);
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    @Override
    public String getString() throws SQLException {
        int v = this.getInt();
        if (v == 0 && this.wasNull()) {
            return null;
        }
        return KylinDateAccessor.dateAsString(v, null);
    }

    @Override
    public long getLong() throws SQLException {
        Date date = this.getDate(null);
        return date == null ? 0L : date.getTime() / 86400000L;
    }

    private static String dateAsString(int v, Calendar calendar) {
        AvaticaUtils.discard(calendar);
        return DateTimeUtils.unixDateToString(v);
    }
}

