/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinCheckSql;
import org.apache.kylin.jdbc.KylinJdbcFactory;
import org.apache.kylin.jdbc.LoggerUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaPreparedStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinConnection
extends AvaticaConnection {
    private static final Logger logger = LoggerFactory.getLogger(KylinConnection.class);
    private final String baseUrl;
    private final String project;
    private final IRemoteClient remoteClient;

    protected KylinConnection(UnregisteredDriver driver, KylinJdbcFactory factory, String url, Properties info) throws SQLException {
        super(driver, factory, url, info);
        LoggerUtils.entry(logger);
        this.checkProperties();
        String odbcUrl = url;
        odbcUrl = odbcUrl.replaceAll("jdbc:kylin:([A-Za-z0-9\\_]+?=.*?;)*?//", "");
        String[] temps0 = odbcUrl.split("\\?");
        odbcUrl = temps0[0];
        String[] temps = odbcUrl.split("/");
        assert (temps.length == 2);
        this.baseUrl = temps[0];
        this.project = temps[1];
        logger.info("------------------------");
        logger.info("Kylin Connection Info:");
        logger.info("base url: {}", (Object)this.baseUrl);
        logger.info("project name: {}", (Object)this.project);
        info.entrySet().stream().filter(infoEntry -> !String.valueOf(infoEntry.getKey()).equalsIgnoreCase("password")).forEach(infoEntry -> logger.info("{}: {}", infoEntry.getKey(), infoEntry.getValue()));
        logger.info("------------------------");
        this.remoteClient = factory.newRemoteClient(this);
        try {
            this.remoteClient.connect();
        }
        catch (IOException e) {
            try {
                this.remoteClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.error("Connect Kylin failed: ", e);
            throw new SQLException(e);
        }
        LoggerUtils.exit(logger);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    String getProject() {
        return this.project;
    }

    Properties getConnectionProperties() {
        return this.info;
    }

    private void checkProperties() {
        String executeAs = this.info.getProperty("EXECUTE_AS_USER_ID");
        if (executeAs != null) {
            if (executeAs.isEmpty()) {
                IllegalArgumentException e = new IllegalArgumentException("The parameter \u201cEXECUTE_AS_USER_ID\u201d can\u2019t be empty. please contact your system admin and check its value in the connection string for Kylin.");
                logger.error(e.getMessage());
                throw e;
            }
            if (executeAs.length() > 1024) {
                IllegalArgumentException e = new IllegalArgumentException("The value of parameter EXECUTE_AS_USER_ID can\u2019t exceed 1024 characters. Please shorten your user id value.");
                logger.error(e.getMessage());
                throw e;
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        LoggerUtils.entry(logger);
        if (this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isAutoCommit() == null) {
            this.setAutoCommit(true);
        }
        boolean isAutoCommit = super.getAutoCommit();
        LoggerUtils.exit(logger);
        return isAutoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        LoggerUtils.entry(logger);
        if (this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl()).isReadOnly() == null) {
            this.setReadOnly(true);
        }
        boolean isReadOnly = super.isReadOnly();
        LoggerUtils.exit(logger);
        return isReadOnly;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        LoggerUtils.entry(logger);
        Meta.Signature sig = this.mockPreparedSignature(sql);
        AvaticaPreparedStatement preparedStatement = this.factory().newPreparedStatement(this, null, sig, resultSetType, resultSetConcurrency, resultSetHoldability);
        LoggerUtils.exit(logger);
        return preparedStatement;
    }

    Meta.Signature mockPreparedSignature(String sql) {
        ArrayList<AvaticaParameter> params = new ArrayList<AvaticaParameter>();
        int placeholderCount = KylinCheckSql.countDynamicPlaceholder(sql);
        for (int i = 1; i <= placeholderCount; ++i) {
            AvaticaParameter param = new AvaticaParameter(false, 0, 0, 0, null, null, null);
            params.add(param);
        }
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        Map<String, Object> internalParams = Collections.emptyMap();
        return new Meta.Signature(columns, sql, params, internalParams, Meta.CursorFactory.ARRAY, Meta.StatementType.SELECT);
    }

    private KylinJdbcFactory factory() {
        return (KylinJdbcFactory)this.factory;
    }

    public IRemoteClient getRemoteClient() {
        return this.remoteClient;
    }

    @Override
    public void close() throws SQLException {
        LoggerUtils.entry(logger);
        super.close();
        try {
            this.remoteClient.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        LoggerUtils.exit(logger);
    }
}

