/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinMeta;
import org.apache.kylin.jdbc.LoggerUtils;
import org.apache.kylin.jdbc.json.GenericResponse;
import org.apache.kylin.jdbc.json.PreparedQueryRequest;
import org.apache.kylin.jdbc.json.SQLResponseStub;
import org.apache.kylin.jdbc.json.StatementParameter;
import org.apache.kylin.jdbc.json.TableMetaStub;
import org.apache.kylin.jdbc.json.TableWithComment;
import org.apache.kylin.jdbc.json.TablesWithCommentResponse;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.config.RequestConfig;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.kylin.jdbc.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.jdbc.shaded.org.apache.http.config.Registry;
import org.apache.kylin.jdbc.shaded.org.apache.http.config.RegistryBuilder;
import org.apache.kylin.jdbc.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.kylin.jdbc.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.kylin.jdbc.shaded.org.apache.http.entity.ContentType;
import org.apache.kylin.jdbc.shaded.org.apache.http.entity.StringEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.client.HttpClientBuilder;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.client.HttpClients;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.kylin.jdbc.shaded.org.apache.http.ssl.SSLContexts;
import org.apache.kylin.jdbc.shaded.org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinClient
implements IRemoteClient {
    private static final Logger logger = LoggerFactory.getLogger(KylinClient.class);
    private final KylinConnection conn;
    private final Properties connProps;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper jsonMapper;
    private static final int POOL_MAX = 10;
    private static final int POOL_MIN = 0;
    private static final int RESPONSE_CODE_200 = 200;
    private static final int RESPONSE_CODE_201 = 201;
    private static final String APPLICATION = "application/json";
    private static final String TIME_ZONE = "UTC";
    private static final String AUTH_METHOD = "Basic ";

    public KylinClient(KylinConnection conn) {
        LoggerUtils.entry(logger);
        this.conn = conn;
        this.connProps = conn.getConnectionProperties();
        this.httpClient = this.buildHttpClient();
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        LoggerUtils.exit(logger);
    }

    private CloseableHttpClient buildHttpClient() {
        PoolingHttpClientConnectionManager cm;
        HttpClientBuilder builder = HttpClients.custom();
        int timeout = Integer.parseInt(this.connProps.getProperty("timeout", "0"));
        RequestConfig rconf = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        builder.setDefaultRequestConfig(rconf);
        logger.debug("use connection timeout " + timeout);
        if (this.isSSL()) {
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial((x509Certificates, s) -> true).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true);
                Registry<ConnectionSocketFactory> r = RegistryBuilder.create().register("https", sslsf).build();
                cm = new PoolingHttpClientConnectionManager(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.debug("use SSL connection with optimistic trust");
        } else {
            cm = new PoolingHttpClientConnectionManager();
            logger.debug("use non-SSL connection");
        }
        int pool = Integer.parseInt(this.connProps.getProperty("pool", "1"));
        if (pool > 10 || pool < 0) {
            logger.debug("invalid 'pool', reset to default");
            pool = 1;
        }
        if (pool == 0) {
            logger.debug("use NO connection pool");
        } else {
            cm.setDefaultMaxPerRoute(pool);
            cm.setMaxTotal(pool);
            logger.debug("use connection pool size " + pool);
        }
        builder.setConnectionManager(cm);
        return builder.build();
    }

    public static Class convertType(int sqlType) {
        Class<Object> result = Object.class;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                result = String.class;
                break;
            }
            case 2: 
            case 3: {
                result = BigDecimal.class;
                break;
            }
            case -7: 
            case 16: {
                result = Boolean.class;
                break;
            }
            case -6: {
                result = Byte.class;
                break;
            }
            case 5: {
                result = Short.class;
                break;
            }
            case 4: {
                result = Integer.class;
                break;
            }
            case -5: {
                result = Long.class;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                result = Double.class;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = Byte[].class;
                break;
            }
            case 91: {
                result = Date.class;
                break;
            }
            case 92: {
                result = Time.class;
                break;
            }
            case 93: {
                result = Timestamp.class;
                break;
            }
        }
        return result;
    }

    public Object wrapObject(String value, int sqlType) {
        if (null == value) {
            return null;
        }
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return value;
            }
            case 2: 
            case 3: {
                return new BigDecimal(value);
            }
            case -7: 
            case 16: {
                return Boolean.parseBoolean(value);
            }
            case -6: {
                return Byte.parseByte(value);
            }
            case 5: {
                return Short.parseShort(value);
            }
            case 4: {
                return Integer.parseInt(value);
            }
            case -5: {
                return Long.parseLong(value);
            }
            case 6: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case 7: 
            case 8: {
                return Double.parseDouble(value);
            }
            case -4: 
            case -3: 
            case -2: {
                return value.getBytes(Charset.defaultCharset());
            }
            case 91: {
                return this.dateConverter(value);
            }
            case 92: {
                return this.timeConverter(value);
            }
            case 93: {
                return this.timestampConverter(value);
            }
        }
        return value;
    }

    private Date dateConverter(String value) {
        try {
            return new Date(this.parseDateTime(value, "yyyy-MM-dd"));
        }
        catch (ParseException ex) {
            logger.error("parse date failed!", ex);
            return null;
        }
    }

    private Time timeConverter(String value) {
        try {
            return new Time(this.parseDateTime(value, "HH:mm:ss"));
        }
        catch (ParseException ex) {
            logger.error("parse time failed!", ex);
            return null;
        }
    }

    private Timestamp timestampConverter(String value) {
        String[] formats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss"};
        ParseException ex = null;
        for (String format : formats) {
            try {
                return new Timestamp(this.parseDateTime(value, format));
            }
            catch (ParseException e) {
                ex = e;
            }
        }
        logger.error("parse timestamp failed!", ex);
        return null;
    }

    private long parseDateTime(String value, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.getDefault(Locale.Category.FORMAT));
        formatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE));
        return formatter.parse(value).getTime();
    }

    private boolean isSSL() {
        return Boolean.parseBoolean(this.connProps.getProperty("ssl", "false"));
    }

    private String baseUrl() {
        return (this.isSSL() ? "https://" : "http://") + this.conn.getBaseUrl();
    }

    private void addHttpHeadersV2(HttpRequestBase method) {
        String headerVal = "application/vnd.apache.kylin-v4-public+json, text/plain, */*";
        method.addHeader("Accept", headerVal);
        this.addCommonHttpHeaders(method);
    }

    private void addCommonHttpHeaders(HttpRequestBase method) {
        method.addHeader("Content-Type", APPLICATION);
        method.addHeader("User-Agent", "KylinJDBCDriver");
        String authToken = this.connProps.getProperty("auth-token");
        if (authToken == null || authToken.trim().isEmpty()) {
            String username = this.connProps.getProperty("user");
            String password = this.connProps.getProperty("password");
            authToken = DatatypeConverter.printBase64Binary((byte[])(username + ":" + password).getBytes(Charset.defaultCharset()));
        }
        method.addHeader("Authorization", AUTH_METHOD + authToken);
        method.addHeader("Auto", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        LoggerUtils.entry(logger);
        HttpPost post = new HttpPost(this.baseUrl() + "/kylin/api/user/authentication");
        this.addHttpHeadersV2(post);
        StringEntity requestEntity = new StringEntity("{}", ContentType.create(APPLICATION, "UTF-8"));
        post.setEntity(requestEntity);
        try {
            CloseableHttpResponse response = this.httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(post, response);
            }
        }
        finally {
            post.releaseConnection();
        }
        LoggerUtils.exit(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KylinMeta.KMetaProject retrieveMetaData(String project) throws IOException {
        List<TableMetaStub> tableMetaStubs;
        LoggerUtils.entry(logger);
        if (!this.conn.getProject().equals(project)) {
            throw new IllegalArgumentException("Project name [" + project + "] not fit current connection[" + this.conn.getProject() + "]");
        }
        String url = this.baseUrl() + "/kylin/api/query/tables_and_columns?project=" + project;
        HttpGet get = new HttpGet(url);
        this.addHttpHeadersV2(get);
        try {
            CloseableHttpResponse response = this.httpClient.execute(get);
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(get, response);
            }
            GenericResponse<List<TableMetaStub>> tableMetaStubVPlus = this.jsonMapper.readValue(response.getEntity().getContent(), new TypeReference<GenericResponse<List<TableMetaStub>>>(){});
            if (tableMetaStubVPlus == null || tableMetaStubVPlus.getData() == null) {
                throw new IOException("Response abnormal without data");
            }
            tableMetaStubs = tableMetaStubVPlus.getData();
        }
        finally {
            get.releaseConnection();
        }
        String urlWithComment = this.baseUrl() + "/kylin/api/tables?project=" + project + "&page_size=" + Integer.MAX_VALUE;
        HttpGet getWithComment = new HttpGet(urlWithComment);
        this.addHttpHeadersV2(getWithComment);
        try {
            CloseableHttpResponse responseWithComment = this.httpClient.execute(getWithComment);
            GenericResponse<TablesWithCommentResponse> tablesWithCommentResponseVPlus = this.jsonMapper.readValue(responseWithComment.getEntity().getContent(), new TypeReference<GenericResponse<TablesWithCommentResponse>>(){});
            TablesWithCommentResponse tablesWithCommentResponse = tablesWithCommentResponseVPlus.getData();
            List<TableWithComment> tableWithComments = tablesWithCommentResponse.getValue();
            HashMap<String, String> columnWithCommentMap = new HashMap<String, String>();
            for (TableWithComment tableWithComment : tableWithComments) {
                for (TableWithComment.ColumnWithComment columnWithComment : tableWithComment.getColumns()) {
                    String keyWithComment = tableWithComment.getDatabase() + "." + tableWithComment.getName() + "." + columnWithComment.getName();
                    columnWithCommentMap.put(keyWithComment, columnWithComment.getComment());
                }
            }
            for (TableMetaStub tableMetaStub : tableMetaStubs) {
                for (TableMetaStub.ColumnMetaStub columnMetaStub : tableMetaStub.getColumns()) {
                    String keyMetaStub = tableMetaStub.getTABLE_SCHEM() + "." + tableMetaStub.getTABLE_NAME() + "." + columnMetaStub.getCOLUMN_NAME();
                    if (!columnWithCommentMap.containsKey(keyMetaStub)) continue;
                    columnMetaStub.setREMARKS((String)columnWithCommentMap.get(keyMetaStub));
                }
            }
        }
        catch (Exception e) {
            logger.error("Get comment failed:" + e.getMessage(), e);
        }
        finally {
            getWithComment.releaseConnection();
        }
        List<KylinMeta.KMetaTable> tables = this.convertMetaTables(tableMetaStubs);
        List<KylinMeta.KMetaSchema> schemas = this.convertMetaSchemas(tables);
        List<KylinMeta.KMetaCatalog> catalogs = this.convertMetaCatalogs(schemas);
        KylinMeta.KMetaProject metaProject = new KylinMeta.KMetaProject(project, catalogs);
        LoggerUtils.exit(logger);
        return metaProject;
    }

    private List<KylinMeta.KMetaCatalog> convertMetaCatalogs(List<KylinMeta.KMetaSchema> schemas) {
        LinkedHashMap<String, List> catalogMap = new LinkedHashMap<String, List>();
        for (KylinMeta.KMetaSchema schema : schemas) {
            List list = catalogMap.computeIfAbsent(schema.tableCatalog, k -> new ArrayList());
            list.add(schema);
        }
        ArrayList<KylinMeta.KMetaCatalog> result = new ArrayList<KylinMeta.KMetaCatalog>();
        for (List catSchemas : catalogMap.values()) {
            String catalog = ((KylinMeta.KMetaSchema)catSchemas.get((int)0)).tableCatalog;
            result.add(new KylinMeta.KMetaCatalog(catalog, catSchemas));
        }
        return result;
    }

    private List<KylinMeta.KMetaSchema> convertMetaSchemas(List<KylinMeta.KMetaTable> tables) {
        LinkedHashMap<String, List> schemaMap = new LinkedHashMap<String, List>();
        for (KylinMeta.KMetaTable table : tables) {
            String key = table.tableCat + "!!" + table.tableSchem;
            List list = schemaMap.computeIfAbsent(key, k -> new ArrayList());
            list.add(table);
        }
        ArrayList<KylinMeta.KMetaSchema> result = new ArrayList<KylinMeta.KMetaSchema>();
        for (List schemaTables : schemaMap.values()) {
            String catalog = ((KylinMeta.KMetaTable)schemaTables.get((int)0)).tableCat;
            String schema = ((KylinMeta.KMetaTable)schemaTables.get((int)0)).tableSchem;
            result.add(new KylinMeta.KMetaSchema(catalog, schema, schemaTables));
        }
        return result;
    }

    private List<KylinMeta.KMetaTable> convertMetaTables(List<TableMetaStub> tableMetaStubs) {
        ArrayList<KylinMeta.KMetaTable> result = new ArrayList<KylinMeta.KMetaTable>(tableMetaStubs.size());
        for (TableMetaStub tableStub : tableMetaStubs) {
            result.add(this.convertMetaTable(tableStub));
        }
        return result;
    }

    private KylinMeta.KMetaTable convertMetaTable(TableMetaStub tableStub) {
        ArrayList<KylinMeta.KMetaColumn> columns = new ArrayList<KylinMeta.KMetaColumn>(tableStub.getColumns().size());
        for (TableMetaStub.ColumnMetaStub columnStub : tableStub.getColumns()) {
            columns.add(this.convertMetaColumn(columnStub));
        }
        return new KylinMeta.KMetaTable(tableStub.getTABLE_CAT(), tableStub.getTABLE_SCHEM(), tableStub.getTABLE_NAME(), tableStub.getTABLE_TYPE(), columns);
    }

    private KylinMeta.KMetaColumn convertMetaColumn(TableMetaStub.ColumnMetaStub columnStub) {
        return new KylinMeta.KMetaColumn(columnStub.getTABLE_CAT(), columnStub.getTABLE_SCHEM(), columnStub.getTABLE_NAME(), columnStub.getCOLUMN_NAME(), columnStub.getDATA_TYPE(), columnStub.getTYPE_NAME(), columnStub.getCOLUMN_SIZE(), columnStub.getDECIMAL_DIGITS(), columnStub.getNUM_PREC_RADIX(), columnStub.getNULLABLE(), columnStub.getCHAR_OCTET_LENGTH(), columnStub.getORDINAL_POSITION(), columnStub.getIS_NULLABLE(), columnStub.getREMARKS());
    }

    @Override
    public IRemoteClient.QueryResult executeQuery(String sql, List<AvaticaParameter> params, List<Object> paramValues, Map<String, String> queryToggles, String queryId) throws IOException {
        LoggerUtils.entry(logger);
        GenericResponse<SQLResponseStub> queryResp = this.executeKylinQuery(sql, this.convertParameters(params, paramValues), queryToggles, queryId);
        if (logger.isDebugEnabled()) {
            logger.debug("Response:\n {} ", (Object)this.jsonMapper.writeValueAsString(queryResp));
        }
        if (queryResp == null || queryResp.getData() == null) {
            throw new IOException("Response abnormal without data");
        }
        SQLResponseStub resp = queryResp.getData();
        if (resp.getIsException()) {
            throw new IOException(resp.getExceptionMessage());
        }
        List<ColumnMetaData> metas = this.convertColumnMeta(resp);
        List<Object> data = this.convertResultData(resp, metas);
        IRemoteClient.QueryResult result = new IRemoteClient.QueryResult(metas, data, resp.getQueryId(), resp.getDuration(), resp.getResultRowCount());
        LoggerUtils.exit(logger);
        return result;
    }

    private List<StatementParameter> convertParameters(List<AvaticaParameter> params, List<Object> paramValues) {
        ArrayList<StatementParameter> result = new ArrayList<StatementParameter>();
        if (params == null || params.isEmpty()) {
            return result;
        }
        if (params.size() != paramValues.size()) {
            throw new IllegalArgumentException("Param count:" + params.size() + "mismatch values count:" + paramValues.size());
        }
        for (Object v : paramValues) {
            if (v == null) {
                result.add(new StatementParameter(Object.class.getCanonicalName(), null));
                continue;
            }
            result.add(new StatementParameter(v.getClass().getCanonicalName(), String.valueOf(v)));
        }
        return result;
    }

    public GenericResponse<SQLResponseStub> executeKylinQuery(String sql, List<StatementParameter> params, Map<String, String> queryToggles, String queryId) throws IOException {
        String executeAs;
        long start = System.currentTimeMillis();
        String url = this.baseUrl() + "/kylin/api/query";
        String project = this.conn.getProject();
        PreparedQueryRequest request = new PreparedQueryRequest();
        if (null != params) {
            request.setParams(params);
        }
        request.setQueryId(queryId);
        request.setSql(sql);
        request.setProject(project);
        request.setBackdoorToggles(queryToggles);
        int maxRowsNum = Integer.parseInt(queryToggles.get("ATTR_STATEMENT_MAX_ROWS"));
        if (maxRowsNum > 0) {
            request.setLimit(maxRowsNum);
        }
        if ((executeAs = this.connProps.getProperty("EXECUTE_AS_USER_ID")) != null) {
            request.setExecuteAs(executeAs);
            String formatString = "Found the parameter EXECUTE_AS_USER_ID in the connection string. The query will be executed as the user defined in this connection string.\nEXECUTE_AS_USER_ID = {}";
            logger.info(formatString, (Object)executeAs);
        }
        HttpPost post = new HttpPost(url);
        this.addHttpHeadersV2(post);
        String postBody = this.jsonMapper.writeValueAsString(request);
        logger.info("Post body:\n {} ", (Object)postBody);
        StringEntity requestEntity = new StringEntity(postBody, ContentType.create(APPLICATION, "UTF-8"));
        post.setEntity(requestEntity);
        try (CloseableHttpResponse response = this.httpClient.execute(post);){
            if (response.getStatusLine().getStatusCode() != 200 && response.getStatusLine().getStatusCode() != 201) {
                throw this.asIOException(post, response);
            }
            GenericResponse<SQLResponseStub> r = this.jsonMapper.readValue(response.getEntity().getContent(), new TypeReference<GenericResponse<SQLResponseStub>>(){});
            long dur = System.currentTimeMillis() - start;
            SQLResponseStub rr = r.getData();
            if (maxRowsNum > 0 && rr.getResults().size() > maxRowsNum) {
                rr.setResults(rr.getResults().subList(0, maxRowsNum));
            }
            logger.info("Query " + rr.getQueryId() + " returned " + (rr.getIsException() ? r.getCode() + "+ex" : r.getCode()) + " in " + dur + " millis at client, " + rr.getDuration() + " millis at server");
            GenericResponse<SQLResponseStub> genericResponse = r;
            return genericResponse;
        }
    }

    private List<ColumnMetaData> convertColumnMeta(SQLResponseStub queryResp) {
        ArrayList<ColumnMetaData> metas = new ArrayList<ColumnMetaData>();
        for (int i = 0; i < queryResp.getColumnMetas().size(); ++i) {
            SQLResponseStub.ColumnMetaStub scm = queryResp.getColumnMetas().get(i);
            Class<Number> columnClass = KylinClient.convertType(scm.getColumnType());
            int columnType = scm.getColumnType();
            String columnTypeName = scm.getColumnTypeName();
            if (columnClass == BigDecimal.class) {
                columnClass = Number.class;
            } else if (columnType == -1) {
                columnType = 12;
            }
            ColumnMetaData.ScalarType type = ColumnMetaData.scalar(columnType, columnTypeName, ColumnMetaData.Rep.of(columnClass));
            ColumnMetaData meta = new ColumnMetaData(i, scm.isAutoIncrement(), scm.isCaseSensitive(), scm.isSearchable(), scm.isCurrency(), scm.getIsNullable(), scm.isSigned(), scm.getDisplaySize(), scm.getLabel(), scm.getName(), scm.getSchemaName(), scm.getPrecision(), scm.getScale(), scm.getTableName(), scm.getSchemaName(), type, scm.isReadOnly(), scm.isWritable(), scm.isWritable(), columnClass.getCanonicalName());
            metas.add(meta);
        }
        return metas;
    }

    private List<Object> convertResultData(SQLResponseStub queryResp, List<ColumnMetaData> metas) {
        List<String[]> stringResults = queryResp.getResults();
        ArrayList<Object> data = new ArrayList<Object>(stringResults.size());
        for (String[] result : stringResults) {
            Object[] row = new Object[result.length];
            for (int i = 0; i < result.length; ++i) {
                ColumnMetaData meta = metas.get(i);
                row[i] = this.wrapObject(result[i], meta.type.id);
            }
            data.add(row);
        }
        return data;
    }

    private IOException asIOException(HttpRequestBase request, HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String responseStr = EntityUtils.toString(response.getEntity());
        if (responseStr.contains("Error occured while trying to proxy to")) {
            return new IOException("FAILED!\n[Kylin 5][JDBCDriver]  Unsupported Apache Kylin instance, please contact Apache Kylin Community.");
        }
        return new IOException(request.getMethod() + " failed, error code " + statusCode + " and response: " + responseStr);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

