/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.autoheal;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.scheduler.JobFailed;
import org.apache.kylin.engine.spark.scheduler.ResourceLack;
import org.apache.kylin.engine.spark.scheduler.RunJob;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.spark.SparkConf;
import org.apache.spark.application.RetryInfo;
import org.apache.spark.autoheal.Failed;
import org.apache.spark.autoheal.ResolverResult;
import org.apache.spark.autoheal.Success;
import org.apache.spark.dict.IllegalDictEncodeValueException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.KylinJobEventLoop;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class ExceptionTerminator$
implements Logging {
    public static ExceptionTerminator$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ExceptionTerminator$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void resolveException(ResourceLack rl, KylinJobEventLoop eventLoop) {
        ResolverResult result;
        ResolverResult resolverResult;
        KylinBuildEnv env = KylinBuildEnv$.MODULE$.get();
        Throwable throwable = rl.throwable();
        if (throwable instanceof IOException) {
            resolverResult = this.resolveIoException(env, rl.throwable());
        } else if (throwable instanceof OutOfMemoryError) {
            resolverResult = this.resolveOutOfMemoryError(env, rl.throwable());
        } else if (throwable instanceof ClassNotFoundException) {
            ClassNotFoundException classNotFoundException = (ClassNotFoundException)throwable;
            resolverResult = new Failed(classNotFoundException.getMessage(), classNotFoundException);
        } else if (throwable instanceof RuntimeException) {
            resolverResult = this.resolveRuntimeException(env, rl.throwable());
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Retry with increasing memory, caused by: ").append(rl.throwable()).toString());
            resolverResult = this.incMemory(env);
        }
        ResolverResult resolverResult2 = result = resolverResult;
        if (resolverResult2 instanceof Success) {
            Success success = (Success)resolverResult2;
            HashMap<String, String> conf = success.conf();
            KylinBuildEnv$.MODULE$.get().buildJobInfos().recordJobRetryInfos(new RetryInfo(conf, rl.throwable()));
            eventLoop.post(new RunJob());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (resolverResult2 instanceof Failed) {
            Failed failed = (Failed)resolverResult2;
            String message = failed.message();
            Throwable throwable2 = failed.throwable();
            eventLoop.post(new JobFailed(message, throwable2));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)resolverResult2);
        }
    }

    private ResolverResult resolveOutOfMemoryError(KylinBuildEnv env, Throwable throwable) {
        ResolverResult resolverResult;
        if (throwable.getMessage().contains(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key())) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Retry with increasing broadcast memory, set ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" = -1.").toString());
            this.overrideSparkConf(env.sparkConf(), SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1");
            HashMap overrideConf = Maps.newHashMap();
            overrideConf.put(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key(), "-1");
            resolverResult = new Success(overrideConf);
        } else {
            resolverResult = this.incMemory(env);
        }
        return resolverResult;
    }

    private ResolverResult resolveIoException(KylinBuildEnv env, Throwable throwable) {
        ResolverResult resolverResult;
        String noSpaceException = "No space left on device";
        if (throwable.getMessage().contains(noSpaceException)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Resolve 'No space left on device' exception.");
            SparkConf conf = env.sparkConf();
            int retryInstance = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.executor.instances"))).toInt() * 2;
            conf.set("spark.executor.instances", Integer.toString(retryInstance));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Reset ").append("spark.executor.instances").append("=").append(retryInstance).append(" when retry.").toString());
            HashMap overrideConf = Maps.newHashMap();
            overrideConf.put("spark.executor.instances", Integer.toString(retryInstance));
            resolverResult = new Success(overrideConf);
        } else {
            resolverResult = this.incMemory(env);
        }
        return resolverResult;
    }

    private ResolverResult reuseOriginalMemory(Throwable throwable) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Retry with original configuration due to exception ").append(throwable.getClass().getName()).toString());
        HashMap overrideConf = Maps.newHashMap();
        return new Success(overrideConf);
    }

    private ResolverResult resolveRuntimeException(KylinBuildEnv env, Throwable throwable) {
        ResolverResult resolverResult;
        Throwable rootCause = Throwables.getRootCause((Throwable)throwable);
        if (rootCause instanceof IllegalDictEncodeValueException) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Job failed due to dict encode error, rebuild the new dictionary and try again");
            KylinBuildEnv$.MODULE$.get().buildJobInfos().recordJobRetryInfosForSegmentParam("job.retry.segment.force-build-dict", "true");
            resolverResult = this.reuseOriginalMemory(throwable);
        } else {
            resolverResult = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])env.kylinConfig().getJobResourceLackIgnoreExceptionClasses())).contains((Object)throwable.getClass().getName()) ? this.reuseOriginalMemory(throwable) : this.incMemory(env);
        }
        return resolverResult;
    }

    private ResolverResult incMemory(KylinBuildEnv env) {
        ResolverResult resolverResult;
        SparkConf conf = env.sparkConf();
        double gradient = env.kylinConfig().getSparkEngineRetryMemoryGradient();
        long prevMemory = Utils$.MODULE$.byteStringAsMb(conf.get("spark.executor.memory"));
        int retryMemory = (int)Math.ceil((double)prevMemory * gradient);
        double overheadGradient = env.kylinConfig().getSparkEngineRetryOverheadMemoryGradient();
        int retryOverhead = (int)Math.ceil((double)retryMemory * overheadGradient);
        Double proportion = KylinBuildEnv$.MODULE$.get().kylinConfig().getMaxAllocationResourceProportion();
        int maxResourceMemory = (int)((double)env.clusterManager().fetchMaximumResourceAllocation().memory() * Predef$.MODULE$.Double2double(proportion));
        long overheadMem = Utils$.MODULE$.byteStringAsMb(conf.get("spark.executor.memoryOverhead"));
        int maxMemory = (int)((double)maxResourceMemory / (overheadGradient + 1.0));
        int maxOverheadMem = (int)((double)maxMemory * overheadGradient);
        HashMap overrideConf = Maps.newHashMap();
        if (prevMemory == (long)maxMemory) {
            int retryCore = new StringOps(Predef$.MODULE$.augmentString(conf.get("spark.executor.cores"))).toInt() - 1;
            if (retryCore > 0) {
                conf.set("spark.executor.cores", Integer.toString(retryCore));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Retry with decreasing cores, set ").append("spark.executor.cores").append("=").append(retryCore).append(".").toString());
                overrideConf.put("spark.executor.cores", Integer.toString(retryCore));
                resolverResult = new Success(overrideConf);
            } else {
                resolverResult = new Failed(new StringBuilder(78).append("Retry configuration is invalid.").append(" ").append("spark.executor.cores").append("=").append(retryCore).append(", ").append("spark.executor.memory").append("=").append(prevMemory).append(".").toString(), new RuntimeException());
            }
        } else if (retryMemory > maxMemory) {
            if ((long)maxMemory > prevMemory) {
                conf.set("spark.executor.memory", new StringBuilder(2).append(maxMemory).append("MB").toString());
                conf.set("spark.executor.memoryOverhead", new StringBuilder(2).append(maxOverheadMem).append("MB").toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Retry with maximum memory, set ").append("spark.executor.memory").append("=").append(conf.get("spark.executor.memory")).append(", ").append("spark.executor.memoryOverhead").append("=").append(conf.get("spark.executor.memoryOverhead")).append(".").toString());
                overrideConf.put("spark.executor.memory", new StringBuilder(2).append(maxMemory).append("MB").toString());
                overrideConf.put("spark.executor.memoryOverhead", new StringBuilder(2).append(maxOverheadMem).append("MB").toString());
                resolverResult = new Success(overrideConf);
            } else {
                resolverResult = new Failed(new StringBuilder(138).append("Memory retried is too small due to lack of resource memory.").append(" Retried memory ").append("spark.executor.memory").append("=").append(maxMemory).append(" MB, prevMemory ").append("spark.executor.memory").append("=").append(prevMemory).append(" MB").toString(), new RuntimeException());
            }
        } else {
            conf.set("spark.executor.memory", new StringBuilder(2).append(retryMemory).append("MB").toString());
            conf.set("spark.executor.memoryOverhead", new StringBuilder(2).append(retryOverhead).append("MB").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Retry with increasing memory, set ").append("spark.executor.memory").append("=").append(conf.get("spark.executor.memory")).append(", ").append("spark.executor.memoryOverhead").append("=").append(conf.get("spark.executor.memoryOverhead")).append(".").toString());
            overrideConf.put("spark.executor.memory", new StringBuilder(2).append(retryMemory).append("MB").toString());
            overrideConf.put("spark.executor.memoryOverhead", new StringBuilder(2).append(retryOverhead).append("MB").toString());
            resolverResult = new Success(overrideConf);
        }
        return resolverResult;
    }

    public void overrideSparkConf(SparkConf sparkConf, String key, String value) {
        sparkConf.set(key, value);
    }

    private ExceptionTerminator$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

