/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterBuildResourceMerger
extends MetadataMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AfterBuildResourceMerger.class);

    public AfterBuildResourceMerger(KylinConfig config, String project) {
        super(config, project);
    }

    public NDataLayout[] merge(String dataflowId, Set<String> segmentId, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType, Set<Long> partitions) {
        switch (jobType) {
            case INDEX_BUILD: 
            case SUB_PARTITION_BUILD: {
                return this.mergeAfterCatchup(dataflowId, segmentId, layoutIds, remoteResourceStore, partitions);
            }
            case INC_BUILD: {
                Preconditions.checkArgument((segmentId.size() == 1 ? 1 : 0) != 0);
                return this.mergeAfterIncrement(dataflowId, segmentId.iterator().next(), layoutIds, remoteResourceStore);
            }
        }
        throw new UnsupportedOperationException("Error job type: " + jobType);
    }

    public NDataLayout[] merge(MergerInfo.TaskMergeInfo info) {
        try (ResourceStore buildResourceStore = ExecutableUtils.getRemoteStore((KylinConfig)this.getConfig(), (String)info.getOutputMetaUrl());){
            String dataFlowId = info.getDataFlowId();
            Set segmentIds = info.getSegmentIds();
            Set layoutIds = info.getLayoutIds();
            Set partitionIds = info.getPartitionIds();
            JobTypeEnum jobType = info.getJobType();
            boolean needBuildSnapshots = info.isNeedBuildSnapshots();
            NDataLayout[] nDataLayouts = this.merge(dataFlowId, segmentIds, layoutIds, buildResourceStore, jobType, partitionIds);
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(dataFlowId);
            if (needBuildSnapshots) {
                this.mergeSnapshotMeta(dataflow, buildResourceStore);
            }
            this.mergeTableExtMeta(dataflow, buildResourceStore);
            NDataLayout[] nDataLayoutArray = nDataLayouts;
            return nDataLayoutArray;
        }
    }

    public NDataLayout[] mergeAfterIncrement(String dataflowId, String segmentId, Set<Long> layoutIds, ResourceStore remoteStore) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(dataflowId);
        NDataflowUpdate dfUpdate = new NDataflowUpdate(dataflowId);
        NDataSegment theSeg = remoteDataflow.getSegment(segmentId).copy();
        List toRemoveSegments = remoteDataflowManager.getToRemoveSegs(remoteDataflow, theSeg);
        if (theSeg.getModel().isMultiPartitionModel()) {
            long lastBuildTime = System.currentTimeMillis();
            theSeg.getMultiPartitions().forEach(partition -> {
                partition.setStatus(PartitionStatusEnum.READY);
                partition.setLastBuildTime(lastBuildTime);
            });
            theSeg.setLastBuildTime(lastBuildTime);
        } else {
            theSeg.setLastBuildTime(theSeg.getSegDetails().getLastModified());
        }
        theSeg.setMvcc(localDataflowManager.getDataflow(dataflowId).getSegment(segmentId).getMvcc());
        this.resetBreakpoints(theSeg);
        theSeg.setStatus(SegmentStatusEnum.READY);
        dfUpdate.setToUpdateSegs(new NDataSegment[]{theSeg});
        dfUpdate.setToRemoveSegs(toRemoveSegments.toArray(new NDataSegment[toRemoveSegments.size()]));
        dfUpdate.setToAddOrUpdateLayouts(theSeg.getSegDetails().getEffectiveLayouts().toArray(new NDataLayout[0]));
        if (remoteDataflow.getModel().getStorageType().isV3Storage()) {
            this.mergeLayoutDetails(this.getProject(), remoteDataflow.getModel().getId(), layoutIds, theSeg, toRemoveSegments, remoteStore.getConfig());
        }
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(dataflowId, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    public NDataLayout[] mergeAfterCatchup(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore, Set<Long> partitionIds) {
        if (CollectionUtils.isNotEmpty(partitionIds)) {
            return this.mergeMultiPartitionModelAfterCatchUp(flowName, segmentIds, layoutIds, remoteStore, partitionIds);
        }
        return this.mergeNormalModelAfterCatchUp(flowName, segmentIds, layoutIds, remoteStore);
    }

    public NDataLayout[] mergeNormalModelAfterCatchUp(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow dataflow = localDataflowManager.getDataflow(flowName);
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(flowName);
        NDataflowUpdate dfUpdate = new NDataflowUpdate(flowName);
        ArrayList addCuboids = Lists.newArrayList();
        Set<Long> availableLayoutIds = this.getAvailableLayoutIds(dataflow, layoutIds);
        ArrayList segsToUpdate = Lists.newArrayList();
        for (String segId : segmentIds) {
            NDataSegment localSeg = dataflow.getSegment(segId);
            NDataSegment remoteSeg = remoteDataflow.getSegment(segId).copy();
            if (this.isUnavailableSegment(localSeg)) continue;
            remoteSeg.setLastBuildTime(remoteSeg.getSegDetails().getLastModified());
            for (long layoutId : availableLayoutIds) {
                NDataLayout dataCuboid = remoteSeg.getLayout(layoutId, true);
                Preconditions.checkNotNull((Object)dataCuboid);
                addCuboids.add(dataCuboid);
            }
            remoteSeg.setMvcc(localSeg.getMvcc());
            if (remoteDataflow.getModel().getStorageType().isV3Storage()) {
                this.mergeLayoutDetails(this.getProject(), remoteDataflow.getModel().getId(), layoutIds, remoteSeg, segsToUpdate, remoteStore.getConfig());
            }
            this.resetBreakpoints(remoteSeg);
            segsToUpdate.add(remoteSeg);
        }
        dfUpdate.setToUpdateSegs(segsToUpdate.toArray(new NDataSegment[0]));
        dfUpdate.setToAddOrUpdateLayouts(addCuboids.toArray(new NDataLayout[0]));
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(flowName, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    private boolean isUnavailableSegment(NDataSegment localSeg) {
        if (localSeg == null) {
            return true;
        }
        return localSeg.getStatus() != SegmentStatusEnum.READY && localSeg.getStatus() != SegmentStatusEnum.WARNING;
    }

    public NDataLayout[] mergeMultiPartitionModelAfterCatchUp(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore, Set<Long> partitionIds) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow localDataflow = localDataflowManager.getDataflow(flowName);
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(flowName);
        NDataflow dataflow = localDataflowManager.getDataflow(flowName);
        NDataflowUpdate dfUpdate = new NDataflowUpdate(flowName);
        ArrayList upsertCuboids = Lists.newArrayList();
        Set<Long> availableLayoutIds = this.getAvailableLayoutIds(dataflow, layoutIds);
        ArrayList segsToUpdate = Lists.newArrayList();
        for (String segId : segmentIds) {
            NDataSegment localSeg = localDataflow.getSegment(segId).copy();
            NDataSegment remoteSeg = remoteDataflow.getSegment(segId).copy();
            if (this.isUnavailableSegment(localSeg)) continue;
            NDataSegment updateSegment = this.upsertSegmentPartition(localSeg, remoteSeg, partitionIds);
            for (long layoutId : availableLayoutIds) {
                NDataLayout remoteLayout = remoteSeg.getLayout(layoutId);
                NDataLayout localLayout = localSeg.getLayout(layoutId);
                NDataLayout upsertLayout = this.upsertLayoutPartition(localLayout, remoteLayout, partitionIds);
                if (upsertLayout == null) {
                    log.warn("Layout {} is null in segment {}. Segment have layouts {} ", new Object[]{layoutId, segId, remoteSeg.getLayoutIds()});
                }
                upsertCuboids.add(upsertLayout);
            }
            segsToUpdate.add(updateSegment);
        }
        dfUpdate.setToUpdateSegs(segsToUpdate.toArray(new NDataSegment[0]));
        dfUpdate.setToAddOrUpdateLayouts(upsertCuboids.toArray(new NDataLayout[0]));
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(flowName, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    private void resetBreakpoints(NDataSegment dataSegment) {
        dataSegment.setFactViewReady(false);
        dataSegment.setDictReady(false);
        if (!this.getConfig().isPersistFlatTableEnabled()) {
            dataSegment.setFlatTableReady(false);
        }
        if (Objects.nonNull(dataSegment.getModel()) && Objects.nonNull(dataSegment.getModel().getMultiPartitionDesc())) {
            dataSegment.setFlatTableReady(false);
        } else {
            dataSegment.setSnapshotReady(false);
        }
    }
}

