/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.IJobProgressReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulJobProgressReport
implements IJobProgressReport {
    private static final Logger logger = LoggerFactory.getLogger(RestfulJobProgressReport.class);
    public static final String JOB_HAS_STOPPED = "Job has stopped";

    public synchronized boolean updateSparkJobInfo(Map<String, String> params, String url, String json) {
        block5: {
            String serverAddress = System.getProperty("spark.driver.rest.server.address", "127.0.0.1:7070");
            String requestApi = String.format(Locale.ROOT, "http://%s%s", serverAddress, url);
            int timeOut = Integer.parseInt(params.get("time_out"));
            try {
                RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(timeOut).setConnectTimeout(timeOut).setConnectionRequestTimeout(timeOut).setStaleConnectionCheckEnabled(true).build();
                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                HttpPut httpPut = new HttpPut(requestApi);
                httpPut.addHeader("Content-Type", "application/vnd.apache.kylin-v4+json");
                httpPut.setEntity((HttpEntity)new StringEntity(json, StandardCharsets.UTF_8));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
                int code = response.getStatusLine().getStatusCode();
                InputStream inputStream = response.getEntity().getContent();
                HashMap kylinResponse = (HashMap)JsonUtil.readValue((InputStream)inputStream, HashMap.class);
                if (code == 200 && kylinResponse.get("code").equals("000")) {
                    return true;
                }
                logger.warn("update spark job failed, info: {}", (Object)kylinResponse);
                if (kylinResponse.get("msg").toString().startsWith(JOB_HAS_STOPPED)) {
                    throw new IllegalStateException(JOB_HAS_STOPPED);
                }
            }
            catch (Exception e) {
                if (!KylinConfig.getInstanceFromEnv().isUTEnv()) {
                    logger.error("http request {} failed!", (Object)requestApi, (Object)e);
                }
                if (!(e instanceof IllegalStateException) || !e.getMessage().equals(JOB_HAS_STOPPED)) break block5;
                throw (IllegalStateException)e;
            }
        }
        return false;
    }

    public boolean updateSparkJobExtraInfo(Map<String, String> params, String url, String project, String jobId, Map<String, String> extraInfo) {
        block5: {
            HashMap<String, String> payload = new HashMap<String, String>(5);
            payload.put("project", project);
            payload.put("job_id", jobId);
            payload.put("task_id", System.getProperty("spark.driver.param.taskId", jobId));
            payload.putAll(extraInfo);
            try {
                String payloadJson = JsonUtil.writeValueAsString(payload);
                int retry = 3;
                for (int i = 0; i < retry; ++i) {
                    if (this.updateSparkJobInfo(params, url, payloadJson)) {
                        return Boolean.TRUE;
                    }
                    Thread.sleep(3000L);
                    logger.warn("retry request rest api update spark extra job info");
                }
            }
            catch (InterruptedException exception) {
                logger.error("update spark job extra info failed!", (Throwable)exception);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("update spark job extra info failed!", (Throwable)e);
                if (!(e instanceof IllegalStateException) || !e.getMessage().equals(JOB_HAS_STOPPED)) break block5;
                throw (IllegalStateException)e;
            }
        }
        return Boolean.FALSE;
    }
}

