/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.client.ClientContext;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.volcano.client.DefaultVolcanoClient;
import io.fabric8.volcano.scheduling.v1beta1.Queue;
import io.fabric8.volcano.scheduling.v1beta1.QueueList;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.cluster.K8sClusterManager$;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteUnit;
import org.apache.kylin.common.util.SizeConvertUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0012$\u00011BQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004M\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003D\u0011\u0019q\u0005\u0001)A\u0005\t\"9q\n\u0001b\u0001\n\u0013\u0019\u0005B\u0002)\u0001A\u0003%A\tC\u0004R\u0001\t\u0007I\u0011B\"\t\rI\u0003\u0001\u0015!\u0003E\u0011\u001d\u0019\u0006\u00011A\u0005\nQCqa\u0017\u0001A\u0002\u0013%A\f\u0003\u0004c\u0001\u0001\u0006K!\u0016\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006M\u0002!\te\u001a\u0005\u0006W\u0002!\t\u0005\u001c\u0005\u0006y\u0002!\t! \u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002n\u0001!\t%a\u001c\t\u000f\u00055\u0004\u0001\"\u0011\u0002v!9\u0011Q\u0010\u0001\u0005B\u0005}\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\ty\n\u0001C!\u0003CCq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002P\u0002!\t%!5\b\u000f\u0005]7\u0005#\u0001\u0002Z\u001a1!e\tE\u0001\u00037DaaP\u000f\u0005\u0002\u0005u\u0007bBAp;\u0011\u0005\u0011\u0011\u001d\u0005\b\u0003?lB\u0011\u0001B\u0007\u0011\u001d\u0011Y\"\bC\u0001\u0005;\u0011\u0011c\u0013\u001dt\u00072,8\u000f^3s\u001b\u0006t\u0017mZ3s\u0015\t!S%A\u0004dYV\u001cH/\u001a:\u000b\u0005\u0019:\u0013!B6zY&t'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001[M:\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025k5\t1%\u0003\u00027G\ty\u0011j\u00117vgR,'/T1oC\u001e,'\u000f\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002=O\u0005)1\u000f]1sW&\u0011a(\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\t\u0005\u00025\u0001\u0005y!j\u0014\"`'R+\u0005k\u0018)S\u000b\u001aK\u0005,F\u0001E!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u0003mC:<'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013aa\u0015;sS:<\u0017\u0001\u0005&P\u0005~\u001bF+\u0012)`!J+e)\u0013-!\u0003)\u0019\u0006+\u0011*L?J{E*R\u0001\f'B\u000b%kS0S\u001f2+\u0005%\u0001\u0004E%&3VIU\u0001\b\tJKe+\u0012*!\u0003E!UIR!V\u0019R{f*Q'F'B\u000b5)R\u0001\u0013\t\u00163\u0015)\u0016'U?:\u000bU*R*Q\u0003\u000e+\u0005%\u0001\u0004d_:4\u0017nZ\u000b\u0002+B\u0011a+W\u0007\u0002/*\u0011\u0001,J\u0001\u0007G>lWn\u001c8\n\u0005i;&aC&zY&t7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\ti\u0006\r\u0005\u0002/=&\u0011ql\f\u0002\u0005+:LG\u000fC\u0004b\u0017\u0005\u0005\t\u0019A+\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\u0015]LG\u000f[\"p]\u001aLw\r\u0006\u0002^K\")1+\u0004a\u0001+\u0006qb-\u001a;dQ6\u000b\u00070[7v[J+7o\\;sG\u0016\fE\u000e\\8dCRLwN\\\u000b\u0002QB\u0011A'[\u0005\u0003U\u000e\u0012ABU3t_V\u00148-Z%oM>\f1DZ3uG\"\fV/Z;f\u0003Z\f\u0017\u000e\\1cY\u0016\u0014Vm]8ve\u000e,GCA7q!\t!d.\u0003\u0002pG\t\t\u0012I^1jY\u0006\u0014G.\u001a*fg>,(oY3\t\u000bE|\u0001\u0019\u0001:\u0002\u0013E,X-^3OC6,\u0007CA:{\u001d\t!\b\u0010\u0005\u0002v_5\taO\u0003\u0002xW\u00051AH]8pizJ!!_\u0018\u0002\rA\u0013X\rZ3g\u0013\tY5P\u0003\u0002z_\u0005ir-\u001a;Bm\u0006LG.\u00192mKJ+7o\\;sG\u0016\u0014\u0015PV8mG\u0006tw\u000e\u0006\u0002n}\"1q\u0010\u0005a\u0001\u0003\u0003\tQ!];fk\u0016\u0004B!a\u0001\u0002\u001a5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0004wc\t,G/Y\u0019\u000b\t\u0005-\u0011QB\u0001\u000bg\u000eDW\rZ;mS:<'\u0002BA\b\u0003#\tqA^8mG\u0006twN\u0003\u0003\u0002\u0014\u0005U\u0011a\u00024bEJL7\r\u000f\u0006\u0003\u0003/\t!![8\n\t\u0005m\u0011Q\u0001\u0002\u0006#V,W/Z\u0001\u001cO\u0016$\u0018I^1jY\u0006\u0014G.\u001a*fg>,(oY3CsF+x\u000e^1\u0015\u00075\f\t\u0003C\u0004\u0002$E\u0001\r!!\n\u0002\rE,x\u000e^1t!\u0019\t9#!\f\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003WA\u0015\u0001B;uS2LA!a\f\u0002*\t!A*[:u!\u0011\t\u0019$!\u0011\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\tQ!\\8eK2TA!a\u000f\u0002>\u0005\u0019\u0011\r]5\u000b\t\u0005}\u0012\u0011C\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c\u0018\u0002BA\"\u0003k\u0011QBU3t_V\u00148-Z)v_R\f\u0017\u0001E4fi\u000e\u0003XOQ=Rk\u0006tG/\u001b;z)\u0011\tI%a\u0014\u0011\u00079\nY%C\u0002\u0002N=\u00121!\u00138u\u0011\u001d\t\tF\u0005a\u0001\u0003'\n\u0001\"];b]RLG/\u001f\t\u0005\u0003g\t)&\u0003\u0003\u0002X\u0005U\"\u0001C)vC:$\u0018\u000e^=\u0002'\u001d,GOQ;jY\u0012$&/Y2lS:<WK\u001d7\u0015\u0007I\fi\u0006C\u0004\u0002`M\u0001\r!!\u0019\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a<\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003W\n)G\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\blS2d\u0017\t\u001d9mS\u000e\fG/[8o)\ri\u0016\u0011\u000f\u0005\u0007\u0003g\"\u0002\u0019\u0001:\u0002\u0013)|'m\u0015;fa&#G#B/\u0002x\u0005m\u0004BBA=+\u0001\u0007!/A\u0007k_\n\u001cF/\u001a9Qe\u00164\u0017\u000e\u001f\u0005\u0007\u0003g*\u0002\u0019\u0001:\u0002/%\u001c\u0018\t\u001d9mS\u000e\fG/[8o\u0005\u0016,gnS5mY\u0016$G\u0003BAA\u0003\u000f\u00032ALAB\u0013\r\t)i\f\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0019H\u0006a\u0001e\u0006qq-\u001a;Sk:t\u0017N\\4K_\n\u001cH\u0003BAG\u0003\u001f\u0003R!a\n\u0002.IDq!!%\u0018\u0001\u0004\t\u0019*\u0001\u0004rk\u0016,Xm\u001d\t\u0006\u0003O\t)J]\u0005\u0005\u0003/\u000bICA\u0002TKR\fACZ3uG\"\fV/Z;f'R\fG/[:uS\u000e\u001cHc\u00015\u0002\u001e\")\u0011\u000f\u0007a\u0001e\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u000bbL7\u000f^3e)\u0011\t\t)a)\t\r\u0005M\u0014\u00041\u0001s\u0003\u001d9W\r\u001e)pIN$b!!+\u0002<\u0006}\u0006CBAV\u0003c\u000b)LD\u0002/\u0003[K1!a,0\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\f\u00024*\u0019\u0011qV\u0018\u0011\t\u0005M\u0012qW\u0005\u0005\u0003s\u000b)DA\u0002Q_\u0012Da!!0\u001b\u0001\u0004\u0011\u0018!\u00029OC6,\u0007bBAa5\u0001\u0007\u00111Y\u0001\u0011WV\u0014WM\u001d8fi\u0016\u001c8\t\\5f]R\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fi$\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003\u001b\f9M\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\u00061r-\u001a;BaBd\u0017nY1uS>tg*Y7f\u0005fLE\rF\u0002s\u0003'Dq!!6\u001c\u0001\u0004\tI%A\u0005zCJt\u0017\t\u001d9JI\u0006\t2\nO:DYV\u001cH/\u001a:NC:\fw-\u001a:\u0011\u0005Qj2cA\u000f.oQ\u0011\u0011\u0011\\\u0001\u0015o&$\bnS;cKJtW\r^3t\u00072LWM\u001c;\u0016\t\u0005\r\u0018\u0011\u001e\u000b\t\u0003K\fY0a@\u0003\u0004A!\u0011q]Au\u0019\u0001!q!a; \u0005\u0004\tiOA\u0001U#\u0011\ty/!>\u0011\u00079\n\t0C\u0002\u0002t>\u0012qAT8uQ&tw\rE\u0002/\u0003oL1!!?0\u0005\r\te.\u001f\u0005\u0007\u0003{|\u0002\u0019\u0001:\u0002\r5\f7\u000f^3s\u0011\u0019\u0011\ta\ba\u0001e\u0006Ia.Y7fgB\f7-\u001a\u0005\b\u0005\u000by\u0002\u0019\u0001B\u0004\u0003\u0011\u0011w\u000eZ=\u0011\u000f9\u0012I!a1\u0002f&\u0019!1B\u0018\u0003\u0013\u0019+hn\u0019;j_:\fT\u0003\u0002B\b\u0005'!bA!\u0005\u0003\u0016\t]\u0001\u0003BAt\u0005'!q!a;!\u0005\u0004\ti\u000fC\u0003TA\u0001\u0007Q\u000bC\u0004\u0003\u0006\u0001\u0002\rA!\u0007\u0011\u000f9\u0012I!a1\u0003\u0012\u000512M]3bi\u0016\\UOY3s]\u0016$Xm]\"mS\u0016tG\u000f\u0006\u0004\u0002D\n}!\u0011\u0005\u0005\u0007\u0003{\f\u0003\u0019\u0001:\t\r\t\u0005\u0011\u00051\u0001s\u0001")
public class K8sClusterManager
implements IClusterManager,
Logging {
    private final String JOB_STEP_PREFIX;
    private final String SPARK_ROLE;
    private final String DRIVER;
    private final String DEFAULT_NAMESPACE;
    private KylinConfig config;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KubernetesClient createKubernetesClient(String string, String string2) {
        return K8sClusterManager$.MODULE$.createKubernetesClient(string, string2);
    }

    public static <T> T withKubernetesClient(KylinConfig kylinConfig, Function1<KubernetesClient, T> function1) {
        return K8sClusterManager$.MODULE$.withKubernetesClient(kylinConfig, function1);
    }

    public static <T> T withKubernetesClient(String string, String string2, Function1<KubernetesClient, T> function1) {
        return K8sClusterManager$.MODULE$.withKubernetesClient(string, string2, function1);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String JOB_STEP_PREFIX() {
        return this.JOB_STEP_PREFIX;
    }

    private String SPARK_ROLE() {
        return this.SPARK_ROLE;
    }

    private String DRIVER() {
        return this.DRIVER;
    }

    private String DEFAULT_NAMESPACE() {
        return this.DEFAULT_NAMESPACE;
    }

    private KylinConfig config() {
        return this.config;
    }

    private void config_$eq(KylinConfig x$1) {
        this.config = x$1;
    }

    public void withConfig(KylinConfig config) {
        this.config_$eq(config);
    }

    public ResourceInfo fetchMaximumResourceAllocation() {
        return new ResourceInfo(Integer.MAX_VALUE, 1000);
    }

    public AvailableResource fetchQueueAvailableResource(String queueName) {
        AvailableResource availableResource;
        Object object = new Object();
        try {
            K8sClusterManager$.MODULE$.withKubernetesClient(this.config(), (Function1 & Serializable & scala.Serializable)kubernetesClient -> {
                K8sClusterManager.$anonfun$fetchQueueAvailableResource$1(this, queueName, object, kubernetesClient);
                return BoxedUnit.UNIT;
            });
            availableResource = new AvailableResource(new ResourceInfo(Integer.MAX_VALUE, 1000), new ResourceInfo(Integer.MAX_VALUE, 1000));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                availableResource = (AvailableResource)ex.value();
            }
            throw ex;
        }
        return availableResource;
    }

    public AvailableResource getAvailableResourceByVolcano(Queue queue) {
        Map capability = queue.getSpec().getCapability();
        BigDecimal memoryBytes = Quantity.getAmountInBytes((Quantity)capability.getOrDefault("memory", Quantity.parse((String)new StringBuilder(22).append(Integer.MAX_VALUE).append("Gi").toString())));
        int memory = (int)SizeConvertUtil.byteStringAs((String)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)memoryBytes), "b"), (ByteUnit)ByteUnit.MiB);
        int cpu = this.getCpuByQuantity(capability.getOrDefault("cpu", Quantity.parse((String)"1000")));
        AvailableResource resource = new AvailableResource(new ResourceInfo(memory, cpu), new ResourceInfo(memory, cpu));
        this.log().info("getAvailableResourceByVolcano:{}", new Object[]{resource});
        return resource;
    }

    public AvailableResource getAvailableResourceByQuota(java.util.List<ResourceQuota> quotas) {
        long hardMemoryBytes = quotas.stream().mapToLong(quota -> Quantity.getAmountInBytes((Quantity)quota.getStatus().getHard().getOrDefault("limits.memory", Quantity.parse((String)new StringBuilder(22).append(Integer.MAX_VALUE).append("Gi").toString()))).longValue()).min().getAsLong();
        int hardCpu = quotas.stream().mapToInt(quota -> this.getCpuByQuantity(quota.getStatus().getHard().getOrDefault("limits.cpu", Quantity.parse((String)"1000")))).min().getAsInt();
        Map used = quotas.get(0).getStatus().getUsed();
        int hardMemory = (int)SizeConvertUtil.byteStringAs((String)new StringBuilder(1).append(hardMemoryBytes).append("b").toString(), (ByteUnit)ByteUnit.MiB);
        BigDecimal usedMemoryBytes = Quantity.getAmountInBytes((Quantity)used.getOrDefault("limits.memory", Quantity.parse((String)"0Gi")));
        int usedMemory = (int)SizeConvertUtil.byteStringAs((String)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)usedMemoryBytes), "b"), (ByteUnit)ByteUnit.MiB);
        int usedCpu = new StringOps(Predef$.MODULE$.augmentString(used.getOrDefault("limits.cpu", Quantity.parse((String)"0")).getAmount())).toInt();
        AvailableResource resource = new AvailableResource(new ResourceInfo(hardMemory - usedMemory, hardCpu - usedCpu), new ResourceInfo(hardMemory, hardCpu));
        this.log().info("getAvailableResourceByQuota:{}", new Object[]{resource});
        return resource;
    }

    public int getCpuByQuantity(Quantity quantity) {
        String format = quantity.getFormat();
        if (format != null && format.equalsIgnoreCase("m")) {
            return new StringOps(Predef$.MODULE$.augmentString(quantity.getAmount())).toInt() / 1000;
        }
        return new StringOps(Predef$.MODULE$.augmentString(quantity.getAmount())).toInt();
    }

    public String getBuildTrackingUrl(SparkSession sparkSession) {
        String applicationId = sparkSession.sparkContext().applicationId();
        String trackUrl = (String)sparkSession.sparkContext().uiWebUrl().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Tracking Ur ").append(applicationId).append(" from spark context ").append(trackUrl).append(" ").toString());
        return trackUrl;
    }

    public void killApplication(String jobStepId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Kill Application ").append(jobStepId).append(" !").toString());
        this.killApplication(String.valueOf(this.JOB_STEP_PREFIX()), jobStepId);
    }

    public void killApplication(String jobStepPrefix, String jobStepId) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Kill Application ").append(jobStepPrefix).append(" ").append(jobStepId).append(" !").toString());
        K8sClusterManager$.MODULE$.withKubernetesClient(this.config(), (Function1 & Serializable & scala.Serializable)kubernetesClient -> {
            Object object;
            String pName = new StringBuilder(0).append(jobStepPrefix).append(jobStepId).toString();
            List<Pod> pods = this.getPods(pName, (KubernetesClient)kubernetesClient);
            if (!pods.isEmpty()) {
                NonNamespaceOperation ops = (NonNamespaceOperation)kubernetesClient.pods().inNamespace(kubernetesClient.getNamespace());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("delete pod ").append(pods).toString());
                object = ops.delete((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(pods).asJava());
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public boolean isApplicationBeenKilled(String jobStepId) {
        return BoxesRunTime.unboxToBoolean(K8sClusterManager$.MODULE$.withKubernetesClient(this.config(), (Function1 & Serializable & scala.Serializable)kubernetesClient -> BoxesRunTime.boxToBoolean((boolean)K8sClusterManager.$anonfun$isApplicationBeenKilled$1(this, jobStepId, kubernetesClient))));
    }

    public java.util.List<String> getRunningJobs(Set<String> queues) {
        return Lists.newArrayList();
    }

    public ResourceInfo fetchQueueStatistics(String queueName) {
        return new ResourceInfo(Integer.MAX_VALUE, 1000);
    }

    public boolean applicationExisted(String jobStepId) {
        return BoxesRunTime.unboxToBoolean(K8sClusterManager$.MODULE$.withKubernetesClient(this.config(), (Function1 & Serializable & scala.Serializable)kubernetesClient -> BoxesRunTime.boxToBoolean((boolean)K8sClusterManager.$anonfun$applicationExisted$1(this, jobStepId, kubernetesClient))));
    }

    private List<Pod> getPods(String pName, KubernetesClient kubernetesClient) {
        NonNamespaceOperation ops = (NonNamespaceOperation)kubernetesClient.pods().inNamespace(kubernetesClient.getNamespace());
        List pods = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((PodList)ops.list()).getItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)pod -> BoxesRunTime.boxToBoolean((boolean)K8sClusterManager.$anonfun$getPods$1(this, pName, pod)))).toList();
        return pods;
    }

    public String getApplicationNameById(int yarnAppId) {
        return "";
    }

    public static final /* synthetic */ void $anonfun$fetchQueueAvailableResource$1(K8sClusterManager $this, String queueName$1, Object nonLocalReturnKey1$1, KubernetesClient kubernetesClient) {
        Optional<Queue> optional;
        try (DefaultVolcanoClient volcanoClient = new DefaultVolcanoClient((ClientContext)kubernetesClient);){
            try {
                optional = ((QueueList)volcanoClient.queues().list()).getItems().stream().filter(x$1 -> x$1.getMetadata().getName().equals(queueName$1)).findFirst();
            }
            catch (Throwable e) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to get volcano queue with error '").append(e.getMessage()).append("'.").toString(), e);
                optional = null;
            }
        }
        Optional<Queue> queue = optional;
        if (queue != null && queue.isPresent() && queue.get().getSpec().getCapability() != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)$this.getAvailableResourceByVolcano(queue.get()));
        }
        java.util.List quotas = ((ResourceQuotaList)kubernetesClient.resourceQuotas().list()).getItems();
        if (CollectionUtils.isNotEmpty((Collection)quotas)) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)$this.getAvailableResourceByQuota(quotas));
        }
    }

    public static final /* synthetic */ boolean $anonfun$isApplicationBeenKilled$1(K8sClusterManager $this, String jobStepId$3, KubernetesClient kubernetesClient) {
        List<Pod> pods = $this.getPods(jobStepId$3, kubernetesClient);
        return pods.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$applicationExisted$1(K8sClusterManager $this, String jobStepId$4, KubernetesClient kubernetesClient) {
        String pName = new StringBuilder(0).append($this.JOB_STEP_PREFIX()).append(jobStepId$4).toString();
        List<Pod> pods = $this.getPods(pName, kubernetesClient);
        return !pods.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getPods$1(K8sClusterManager $this, String pName$1, Pod pod) {
        ObjectMeta meta = pod.getMetadata();
        if (!meta.getName().startsWith(pName$1)) return false;
        Object v = meta.getLabels().get($this.SPARK_ROLE());
        String string = $this.DRIVER();
        if (v != null) {
            if (!v.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    public K8sClusterManager() {
        IClusterManager.$init$((IClusterManager)this);
        Logging.$init$((Logging)this);
        this.JOB_STEP_PREFIX = "job-step-";
        this.SPARK_ROLE = "spark-role";
        this.DRIVER = "driver";
        this.DEFAULT_NAMESPACE = "default";
        this.config = null;
    }
}

