/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.engine.spark.job.NSparkCubingJob;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.IndexBuildJobUtil;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableHandleUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableHandleUtils.class);

    public static void recordDownJobStats(AbstractExecutable buildTask, NDataLayout[] addOrUpdateCuboids, String project) {
        String model = buildTask.getTargetSubject();
        long buildEndTime = buildTask.getEndTime();
        long duration = buildTask.getParent().getDuration();
        long byteSize = Arrays.stream(addOrUpdateCuboids).mapToLong(NDataLayout::getByteSize).sum();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        long startOfDay = TimeUtil.getDayStart((long)buildEndTime);
        JobContextUtil.withTxAndRetry(() -> {
            ExecutableManager executableManager = ExecutableManager.getInstance((KylinConfig)kylinConfig, (String)project);
            executableManager.updateJobOutput(buildTask.getParentId(), null, null, null, null, byteSize);
            return true;
        });
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            JobStatisticsManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateStatistics(startOfDay, model, duration, byteSize, 0);
            return true;
        }, (String)project);
    }

    public static List<AbstractExecutable> getNeedMergeTasks(DefaultExecutableOnModel parent) {
        return parent.getTasks().stream().filter(task -> task instanceof NSparkExecutable).filter(task -> ((NSparkExecutable)((Object)task)).needMergeMetadata()).collect(Collectors.toList());
    }

    public static void mergeMetadataForTable(String project, MergerInfo mergerInfo) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            MetadataMerger merger = MetadataMerger.createMetadataMerger(project, mergerInfo.getHandlerType());
            List infoList = mergerInfo.getTaskMergeInfoList();
            Preconditions.checkArgument((infoList.size() == 1 ? 1 : 0) != 0);
            return merger.merge((MergerInfo.TaskMergeInfo)infoList.get(0));
        }, (String)project);
    }

    public static List<NDataLayout[]> mergeMetadata(String project, MergerInfo mergerInfo) {
        return (List)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            MetadataMerger merger = MetadataMerger.createMetadataMerger(project, mergerInfo.getHandlerType());
            ArrayList mergedLayouts = new ArrayList();
            mergerInfo.getTaskMergeInfoList().forEach(info -> mergedLayouts.add(merger.merge((MergerInfo.TaskMergeInfo)info)));
            if (mergerInfo.getHandlerType() == ExecutableHandler.HandlerType.ADD_CUBOID) {
                ExecutableHandleUtils.tryRemoveToBeDeletedLayouts(project, mergerInfo);
            }
            ExecutableHandleUtils.markDFStatus(project, mergerInfo.getModelId());
            return mergedLayouts;
        }, (String)project);
    }

    private static void tryRemoveToBeDeletedLayouts(String project, MergerInfo mergerInfo) {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        AbstractExecutable executable = ExecutableManager.getInstance((KylinConfig)conf, (String)project).getJob(mergerInfo.getJobId());
        if (!(executable instanceof NSparkCubingJob)) {
            return;
        }
        NSparkCubingJob job = (NSparkCubingJob)executable;
        if (job.getSparkCubingStep().getStatus() != ExecutableState.SUCCEED) {
            return;
        }
        boolean layoutsDeletableAfterBuild = Boolean.parseBoolean(job.getParam("layoutsDeletableAfterBuild"));
        if (!layoutsDeletableAfterBuild) {
            return;
        }
        NDataflow df = NDataflowManager.getInstance((KylinConfig)conf, (String)project).getDataflow(job.getTargetModelId());
        IndexPlan indexPlan = NIndexPlanManager.getInstance((KylinConfig)conf, (String)project).getIndexPlan(job.getTargetModelId());
        Set toBeDeletedLayoutIds = indexPlan.getAllToBeDeleteLayoutId();
        if (!toBeDeletedLayoutIds.isEmpty()) {
            Set processedLayouts = mergerInfo.getTaskMergeInfoList().stream().flatMap(taskMergeInfo -> taskMergeInfo.getLayoutIds().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            Segments targetSegments = df.getSegments((Set)Sets.newHashSet((Iterable)job.getTargetSegments()));
            Set prunedToBeDeletedLayoutIds = IndexBuildJobUtil.pruneTBDelLayouts((Set)toBeDeletedLayoutIds.stream().map(arg_0 -> ((IndexPlan)indexPlan).getLayoutEntity(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new)), (Set)processedLayouts.stream().map(arg_0 -> ((IndexPlan)indexPlan).getLayoutEntity(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new)), (NDataflow)df, (IndexPlan)indexPlan, (List)targetSegments).stream().map(LayoutEntity::getId).collect(Collectors.toSet());
            log.info("The final toBeDeletedLayouts: {}", prunedToBeDeletedLayoutIds);
            if (!prunedToBeDeletedLayoutIds.isEmpty()) {
                NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateIndexPlan(mergerInfo.getModelId(), copyForWrite -> copyForWrite.removeLayouts(prunedToBeDeletedLayoutIds, true, true));
            }
        }
    }

    static void markDFStatus(String project, String modelId) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataflow df = dfManager.getDataflow(modelId);
        boolean isOffline = dfManager.isOfflineModel(df);
        RealizationStatusEnum status = df.getStatus();
        if (RealizationStatusEnum.ONLINE == status && isOffline) {
            dfManager.updateDataflowStatus(df.getId(), RealizationStatusEnum.OFFLINE);
        } else if (RealizationStatusEnum.OFFLINE == status && !isOffline) {
            NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateDataflowStatus(df.getId(), RealizationStatusEnum.ONLINE);
        }
    }

    public static void makeSegmentReady(String project, String modelId, String segmentId) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NDataflow df = dfMgr.getDataflow(modelId);
        NDataflowUpdate dfUpdate = new NDataflowUpdate(modelId);
        NDataSegment seg = df.getSegment(segmentId).copy();
        seg.setStatus(SegmentStatusEnum.READY);
        dfUpdate.setToUpdateSegs(new NDataSegment[]{seg});
        dfMgr.updateDataflow(dfUpdate);
        ExecutableHandleUtils.markDFStatus(project, modelId);
    }
}

