/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.scheduler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.engine.spark.utils.ThreadUtils$;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001m3A\u0001D\u0007\u00015!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003$\u0011\u00159\u0003\u0001\"\u0001)\u0011!a\u0003\u0001#b\u0001\n\u0013\u0011\u0003\u0002C\u0017\u0001\u0011\u000b\u0007I\u0011\u0002\u0012\t\u00119\u0002\u0001R1A\u0005\n=B\u0001B\u0004\u0001\t\u0006\u0004%IA\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u00063\u0002!\tA\u0017\u0002\u000b\u0015>\u0014'+\u001e8uS6,'B\u0001\b\u0010\u0003%\u00198\r[3ek2,'O\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007K:<\u0017N\\3\u000b\u0005Q)\u0012!B6zY&t'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\"\\1y)\"\u0014X-\u00193D_VtG/F\u0001$!\taB%\u0003\u0002&;\t\u0019\u0011J\u001c;\u0002\u001f5\f\u0007\u0010\u00165sK\u0006$7i\\;oi\u0002\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u000e\u0011\u0015\t3\u00011\u0001$\u0003)i\u0017N\u001c+ie\u0016\fGm]\u0001\u000b[\u0006DH\u000b\u001b:fC\u0012\u001c\u0018A\u0003;ie\u0016\fG\rU8pYV\t\u0001\u0007\u0005\u00022q5\t!G\u0003\u00024i\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U2\u0014\u0001B;uS2T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s+\u0005Y\u0004CA\u0019=\u0013\ti$G\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\faa];c[&$HC\u0001!D!\ta\u0012)\u0003\u0002C;\t!QK\\5u\u0011\u0015!\u0005\u00021\u0001F\u0003\r1WO\u001c\t\u00049\u0019\u0003\u0015BA$\u001e\u0005%1UO\\2uS>t\u0007'\u0001\ntG\",G-\u001e7f\u0007\",7m\u001b9pS:$HC\u0001!K\u0011\u0015!\u0015\u00021\u0001F\u0003!\u00198\r[3ek2,G\u0003\u0002!N\u001fRCQA\u0014\u0006A\u0002\u0015\u000bAAZ;oG\")\u0001K\u0003a\u0001#\u0006)A-\u001a7bsB\u0011ADU\u0005\u0003'v\u0011A\u0001T8oO\")QK\u0003a\u0001-\u0006!QO\\5u!\t\tt+\u0003\u0002Ye\tAA+[7f+:LG/\u0001\u0005tQV$Hm\\<o)\u0005\u0001\u0005")
public class JobRuntime {
    private int minThreads;
    private int maxThreads;
    private ThreadPoolExecutor threadPool;
    private ScheduledExecutorService scheduler;
    private final int maxThreadCount;
    private volatile byte bitmap$0;

    public int maxThreadCount() {
        return this.maxThreadCount;
    }

    private int minThreads$lzycompute() {
        JobRuntime jobRuntime = this;
        synchronized (jobRuntime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.minThreads = 1;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.minThreads;
    }

    private int minThreads() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.minThreads$lzycompute() : this.minThreads;
    }

    private int maxThreads$lzycompute() {
        JobRuntime jobRuntime = this;
        synchronized (jobRuntime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.maxThreads = Math.max(this.minThreads(), this.maxThreadCount());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxThreads;
    }

    private int maxThreads() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.maxThreads$lzycompute() : this.maxThreads;
    }

    private ThreadPoolExecutor threadPool$lzycompute() {
        JobRuntime jobRuntime = this;
        synchronized (jobRuntime) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.threadPool = ThreadUtils$.MODULE$.newDaemonScalableThreadPool("build-thread", this.minThreads(), this.maxThreads(), 20L, TimeUnit.SECONDS);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.threadPool;
    }

    private ThreadPoolExecutor threadPool() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    private ScheduledExecutorService scheduler$lzycompute() {
        JobRuntime jobRuntime = this;
        synchronized (jobRuntime) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.scheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("build-scheduler");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.scheduler;
    }

    private ScheduledExecutorService scheduler() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public void submit(Function0<BoxedUnit> fun) {
        this.threadPool().submit(new Runnable(null, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
    }

    public void scheduleCheckpoint(Function0<BoxedUnit> fun) {
        this.scheduler().scheduleWithFixedDelay(() -> fun.apply$mcV$sp(), 60L, 60L, TimeUnit.SECONDS);
    }

    public void schedule(Function0<BoxedUnit> func, long delay, TimeUnit unit) {
        this.scheduler().schedule(new Runnable(null, func){
            private final Function0 func$1;

            public void run() {
                this.func$1.apply$mcV$sp();
            }
            {
                this.func$1 = func$1;
            }
        }, delay, unit);
    }

    public void shutdown() {
        this.scheduler().shutdownNow();
        this.threadPool().shutdownNow();
    }

    public JobRuntime(int maxThreadCount) {
        this.maxThreadCount = maxThreadCount;
    }
}

