/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.step.build;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.DFBuilderHelper$;
import org.apache.kylin.engine.spark.builder.NonEquiJoinConditionBuilder$;
import org.apache.kylin.engine.spark.job.FiltersUtil$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.TableMetaManager$;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.engine.spark.utils.SparkDataSource$;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.FutureAction;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkOperation$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.JoinType$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.utils.ProxyThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParMap;
import scala.collection.parallel.TaskSupport;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class FlatTableStage$
implements LogEx {
    public static FlatTableStage$ MODULE$;
    private final KylinConfig conf;
    private boolean inferFiltersEnabled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FlatTableStage$();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private KylinConfig conf() {
        return this.conf;
    }

    public boolean inferFiltersEnabled() {
        return this.inferFiltersEnabled;
    }

    public void inferFiltersEnabled_$eq(boolean x$1) {
        this.inferFiltersEnabled = x$1;
    }

    public Dataset<Row> concatCCs(Dataset<Row> table, scala.collection.immutable.Set<TblColRef> computColumns) {
        scala.collection.immutable.Set<TblColRef> matchedCols = DFBuilderHelper$.MODULE$.selectColumnsInTable(table, computColumns);
        ObjectRef tableWithCcs = ObjectRef.create(table);
        matchedCols.foreach((Function1 & Serializable & scala.Serializable)m -> {
            tableWithCcs.elem = ((Dataset)tableWithCcs.elem).withColumn(NSparkCubingUtil.convertFromDot((String)m.getBackTickIdentity()), functions$.MODULE$.expr(NSparkCubingUtil.convertFromDotWithBackTick((String)m.getBackTickExp())));
            return BoxedUnit.UNIT;
        });
        return (Dataset)tableWithCcs.elem;
    }

    public Dataset<Row> fulfillDS(Dataset<Row> originDS, scala.collection.immutable.Set<TblColRef> cols, TableRef tableRef) {
        Seq<Column> computedColumns = DFBuilderHelper$.MODULE$.chooseSuitableCols(originDS, (Iterable<TblColRef>)cols);
        Dataset<Row> newDS = this.wrapAlias(originDS, tableRef.getAlias(), this.wrapAlias$default$3());
        Column[] selectedColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newDS.schema().fields())).map((Function1 & Serializable & scala.Serializable)tp -> functions$.MODULE$.col(tp.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$plus$plus(computedColumns, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("Table SCHEMA ").append(tableRef.getTableIdentity()).append(" ").append(newDS.schema().treeString()).toString());
        return newDS.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])selectedColumns));
    }

    public Dataset<Row> wrapAlias(Dataset<Row> originDS, String alias, boolean needLog) {
        Dataset newDS;
        block0: {
            Seq newFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originDS.schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                String aliasDotColName = new java.lang.StringBuilder(5).append("`").append(alias).append("`").append(".").append("`").append(f.name()).append("`").toString();
                return NSparkCubingUtil.convertFromDot((String)aliasDotColName);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
            newDS = originDS.toDF(newFields);
            if (!needLog) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Wrap ALIAS ").append(originDS.schema().treeString()).append(" TO ").append(newDS.schema().treeString()).toString());
        }
        return newDS;
    }

    public LogicalPlan wrapAlias(LogicalPlan originPlan, String alias, boolean needLog) {
        LogicalPlan newDS;
        block0: {
            Seq newFields = (Seq)originPlan.output().map((Function1 & Serializable & scala.Serializable)f -> {
                String aliasDotColName = new java.lang.StringBuilder(5).append("`").append(alias).append("`").append(".").append("`").append(f.name()).append("`").toString();
                return NSparkCubingUtil.convertFromDot((String)aliasDotColName);
            }, Seq$.MODULE$.canBuildFrom());
            newDS = SparkOperation$.MODULE$.projectAsAlias(newFields, originPlan);
            if (!needLog) break block0;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Wrap ALIAS ").append(originPlan.schema().treeString()).append(" TO ").append(newDS.schema().treeString()).toString());
        }
        return newDS;
    }

    public boolean wrapAlias$default$3() {
        return true;
    }

    public Dataset<Row> joinAsFlatTable(Dataset<Row> factTable, scala.collection.mutable.Map<JoinTableDesc, Dataset<Row>> joinTableMap, NDataModel model, boolean needLog) {
        return (Dataset)joinTableMap.foldLeft(factTable, (Function2 & Serializable & scala.Serializable)(joinedDataset, tuple) -> MODULE$.joinTableDataset(model.getRootFactTable().getTableDesc(), (JoinTableDesc)tuple._1(), (Dataset<Row>)joinedDataset, (Dataset<Row>)((Dataset)tuple._2()), needLog));
    }

    public boolean joinAsFlatTable$default$4() {
        return true;
    }

    public Dataset<Row> joinTableDataset(TableDesc rootFactDesc, JoinTableDesc lookupDesc, Dataset<Row> rootFactDataset, Dataset<Row> lookupDataset, boolean needLog) {
        Dataset afterJoin;
        block3: {
            TblColRef[] fk;
            afterJoin = rootFactDataset;
            JoinDesc join = lookupDesc.getJoin();
            if (join == null || StringUtils.isEmpty((CharSequence)join.getType())) break block3;
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new RuntimeException(new java.lang.StringBuilder(64).append("Invalid join condition of fact table: ").append(rootFactDesc).append(",fk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).mkString(",")).append(",").append(" lookup table:").append(lookupDesc).append(", pk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pk)).mkString(",")).toString());
            }
            if (needLog) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Lookup table schema ").append(lookupDataset.schema().treeString()).toString());
            }
            Column condition = this.getCondition(join);
            if (needLog) {
                String nonEquiv = join.getNonEquiJoinCondition() == null ? "" : "non-equi ";
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(38).append("Root table ").append(rootFactDesc.getIdentity()).append(",").append(" join table ").append(lookupDesc.getAlias()).append(",").append(" ").append(nonEquiv).append(" condition: ").append(condition.toString()).toString());
            }
            afterJoin = join.getNonEquiJoinCondition() == null && this.inferFiltersEnabled() ? afterJoin.join(FiltersUtil$.MODULE$.inferFilters(pk, lookupDataset), condition, joinType) : afterJoin.join(lookupDataset, condition, joinType);
        }
        return afterJoin;
    }

    public boolean joinTableDataset$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashMap<JoinTableDesc, Dataset<Row>> createJoinTableMap(Seq<JoinTableDesc> joinTableSeq, Function1<TableRef, Dataset<Row>> joinTableFunc) {
        void var3_3;
        LinkedHashMap ret = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set antiFlattenTableSet = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        joinTableSeq.foreach((Function1 & Serializable & scala.Serializable)joinDesc -> {
            BoxedUnit boxedUnit;
            TableRef fkTableRef = joinDesc.getJoin().getFKSide();
            if (fkTableRef == null) {
                throw new IllegalArgumentException("FK table cannot be null");
            }
            String fkTable = fkTableRef.getTableDesc().getIdentity();
            Object object = !joinDesc.isFlattenable() || antiFlattenTableSet.contains((Object)fkTable) ? BoxesRunTime.boxToBoolean((boolean)antiFlattenTableSet.add((Object)joinDesc.getTable())) : BoxedUnit.UNIT;
            if (joinDesc.isFlattenable() && !antiFlattenTableSet.contains((Object)joinDesc.getTable())) {
                TableRef tableRef = joinDesc.getTableRef();
                Dataset tableDS = (Dataset)joinTableFunc.apply((Object)tableRef);
                boxedUnit = ret.put(joinDesc, MODULE$.fulfillDS((Dataset<Row>)tableDS, (scala.collection.immutable.Set<TblColRef>)Predef$.MODULE$.Set().empty(), tableRef));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return var3_3;
    }

    public Column getCondition(JoinDesc join) {
        TblColRef[] pk = join.getPrimaryKeyColumns();
        TblColRef[] fk = join.getForeignKeyColumns();
        Column equalPairs = (Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])pk), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)joinKey -> {
            String fkIdentity = NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._1()).getBackTickIdentity());
            String pkIdentity = NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._2()).getBackTickIdentity());
            return functions$.MODULE$.col(fkIdentity).equalTo((Object)functions$.MODULE$.col(pkIdentity));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$14, x$15) -> x$14.$amp$amp(x$15));
        return join.getNonEquiJoinCondition() == null ? equalPairs : NonEquiJoinConditionBuilder$.MODULE$.convert(join.getNonEquiJoinCondition()).$amp$amp((Object)equalPairs);
    }

    public LogicalPlan joinFactTableWithLookupTables(LogicalPlan rootFactPlan, scala.collection.mutable.Map<JoinTableDesc, LogicalPlan> lookupTableDatasetMap, NDataModel model, boolean needLog) {
        return (LogicalPlan)lookupTableDatasetMap.foldLeft((Object)rootFactPlan, (Function2 & Serializable & scala.Serializable)(joinedDataset, tuple) -> MODULE$.joinTableLogicalPlan(model.getRootFactTable().getTableDesc(), (JoinTableDesc)tuple._1(), (LogicalPlan)joinedDataset, (LogicalPlan)tuple._2(), needLog));
    }

    public LogicalPlan joinTableLogicalPlan(TableDesc rootFactDesc, JoinTableDesc lookupDesc, LogicalPlan rootFactPlan, LogicalPlan lookupPlan, boolean needLog) {
        LogicalPlan afterJoin;
        block3: {
            TblColRef[] fk;
            afterJoin = rootFactPlan;
            JoinDesc join = lookupDesc.getJoin();
            if (join == null || StringUtils.isEmpty((CharSequence)join.getType())) break block3;
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new RuntimeException(new java.lang.StringBuilder(64).append("Invalid join condition of fact table: ").append(rootFactDesc).append(",fk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).mkString(",")).append(",").append(" lookup table:").append(lookupDesc).append(", pk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pk)).mkString(",")).toString());
            }
            Column[] equiConditionColPairs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])pk), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)joinKey -> functions$.MODULE$.col(NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._1()).getBackTickIdentity())).equalTo((Object)functions$.MODULE$.col(NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._2()).getBackTickIdentity()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            if (join.getNonEquiJoinCondition() != null) {
                Column condition = this.getCondition(join);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Root table ").append(rootFactDesc.getIdentity()).append(", join table ").append(lookupDesc.getAlias()).append(", non-equi condition: ").append(condition.toString()).toString());
                afterJoin = new Join(afterJoin, lookupPlan, JoinType$.MODULE$.apply(joinType), Option$.MODULE$.apply((Object)condition.expr()), JoinHint$.MODULE$.NONE());
            } else {
                Column condition = (Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])equiConditionColPairs)).reduce((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> x$16.$amp$amp(x$17));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Root table ").append(rootFactDesc.getIdentity()).append(", join table ").append(lookupDesc.getAlias()).append(", condition: ").append(condition.toString()).toString());
                afterJoin = new Join(afterJoin, lookupPlan, JoinType$.MODULE$.apply(joinType), Option$.MODULE$.apply((Object)condition.expr()), JoinHint$.MODULE$.NONE());
            }
        }
        return afterJoin;
    }

    public boolean joinTableLogicalPlan$default$5() {
        return true;
    }

    public Dataset<Row> changeSchemeToColumnId(Dataset<Row> ds, SegmentFlatTableDesc tableDesc) {
        StructType structType = ds.schema();
        Buffer columnIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tableDesc.getColumnIds()).asScala();
        Buffer columnName2Id = (Buffer)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableDesc.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> NSparkCubingUtil.convertFromDot((String)column.getBackTickIdentity()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)columnIds, Buffer$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map columnName2IdMap = columnName2Id.toMap(Predef$.MODULE$.$conforms());
        Seq encodeSeq = (Seq)((TraversableLike)structType.filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)FlatTableStage$.$anonfun$changeSchemeToColumnId$2(x$18)))).map((Function1 & Serializable & scala.Serializable)tp -> {
            String columnName = new StringOps(Predef$.MODULE$.augmentString(tp.name())).stripSuffix(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
            Integer columnId = (Integer)columnName2IdMap.apply((Object)columnName);
            return functions$.MODULE$.col(tp.name()).alias(new java.lang.StringBuilder(0).append(columnId.toString()).append(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX()).toString());
        }, Seq$.MODULE$.canBuildFrom());
        Buffer columns = (Buffer)columnName2Id.map((Function1 & Serializable & scala.Serializable)tp -> functions$.MODULE$.expr(new java.lang.StringBuilder(2).append("`").append(tp._1()).append("`").toString()).alias(((Integer)tp._2()).toString()), Buffer$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("Select model column is ").append(columns.mkString(",")).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Select model encoding column is ").append(encodeSeq.mkString(",")).toString());
        Buffer selectedColumns = columns.$plus$plus((GenTraversableOnce)encodeSeq);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Select model all column is ").append(selectedColumns.mkString(",")).toString());
        return ds.select((Seq)selectedColumns);
    }

    public String replaceDot(String original, NDataModel model) {
        StringBuilder sb = new StringBuilder(original);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getAllNamedColumns()).asScala()).foreach((Function1 & Serializable & scala.Serializable)namedColumn -> {
            FlatTableStage$.$anonfun$replaceDot$1(sb, namedColumn);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    private void doReplaceDot(StringBuilder sb, String namedCol, String colAliasDotColumn) {
        int start = sb.toString().toLowerCase(Locale.ROOT).indexOf(namedCol);
        while (start != -1) {
            sb.replace(start, start + namedCol.length(), new java.lang.StringBuilder(2).append("`").append(NSparkCubingUtil.convertFromDot((String)colAliasDotColumn)).append("`").toString());
            start = sb.toString().toLowerCase(Locale.ROOT).indexOf(namedCol);
        }
    }

    public void org$apache$kylin$engine$spark$job$step$build$FlatTableStage$$generateLookupTableMeta(String project, LinkedHashMap<JoinTableDesc, Dataset<Row>> lookupTables) {
        block1: {
            KapConfig config = KapConfig.getInstanceFromEnv();
            if (config.isRecordSourceUsage()) {
                lookupTables.keySet().foreach((Function1 & Serializable & scala.Serializable)joinTable -> {
                    FlatTableStage$.$anonfun$generateLookupTableMeta$1(config, project, joinTable);
                    return BoxedUnit.UNIT;
                });
            }
            Map noStatLookupTables = lookupTables.filterKeys((Function1 & Serializable & scala.Serializable)table -> BoxesRunTime.boxToBoolean((boolean)FlatTableStage$.$anonfun$generateLookupTableMeta$3(table)));
            if (!config.getKylinConfig().isNeedCollectLookupTableInfo() || !noStatLookupTables.nonEmpty()) break block1;
            ParMap lookupTablePar = (ParMap)noStatLookupTables.par();
            lookupTablePar.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(lookupTablePar.size())));
            lookupTablePar.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FlatTableStage$.$anonfun$generateLookupTableMeta$4(config, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public long countTableInFiniteTimeOrDefault(Dataset<Row> dataset, String tableName, Duration duration, long defaultCount) {
        long l;
        FutureAction countTask = RDD$.MODULE$.rddToAsyncRDDActions(dataset.rdd(), ClassTag$.MODULE$.apply(Row.class)).countAsync();
        try {
            l = BoxesRunTime.unboxToLong(ProxyThreadUtils$.MODULE$.awaitResult(countTask, duration));
        }
        catch (Exception e) {
            countTask.cancel();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append(tableName).append(" count fail, and return defaultCount ").append(defaultCount).toString(), e);
            l = defaultCount;
        }
        return l;
    }

    public Dataset<Row> createTable(TableRef tableRef, SparkSession spark) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(18).append("Load source table ").append(tableRef.getTableIdentity()).toString());
        return SparkDataSource$.MODULE$.SparkSource(spark).table(tableRef.getTableDesc()).alias(tableRef.getAlias());
    }

    public static final /* synthetic */ boolean $anonfun$changeSchemeToColumnId$2(StructField x$18) {
        return x$18.name().endsWith(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$replaceDot$1(StringBuilder sb$1, NDataModel.NamedColumn namedColumn) {
        block0: {
            String colName = namedColumn.getAliasDotColumn().toLowerCase(Locale.ROOT);
            MODULE$.doReplaceDot(sb$1, colName, namedColumn.getAliasDotColumn());
            String quotedColName = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(colName)).split('.'))).mkString("`", "`.`", "`");
            if (!new StringOps(Predef$.MODULE$.augmentString(quotedColName)).nonEmpty()) break block0;
            MODULE$.doReplaceDot(sb$1, quotedColName, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(namedColumn.getAliasDotColumn())).split('.'))).mkString("`", "`.`", "`"));
        }
    }

    public static final /* synthetic */ void $anonfun$generateLookupTableMeta$1(KapConfig config$1, String project$1, JoinTableDesc joinTable) {
        block0: {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config$1.getKylinConfig(), (String)project$1);
            TableExtDesc table = tableManager.getOrCreateTableExt(joinTable.getTable());
            if (table.getTotalRows() <= 0L) break block0;
            TableMetaManager$.MODULE$.putTableMeta(joinTable.getTable(), 0L, table.getTotalRows());
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("put meta table: ").append(joinTable.getTable()).append(", count: ").append(table.getTotalRows()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$generateLookupTableMeta$3(JoinTableDesc table) {
        return TableMetaManager$.MODULE$.getTableMeta(table.getTable()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$generateLookupTableMeta$4(KapConfig config$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JoinTableDesc joinTableDesc = (JoinTableDesc)tuple2._1();
        Dataset dataset = (Dataset)tuple2._2();
        String tableIdentity = joinTableDesc.getTable();
        BoxedUnit boxedUnit = (BoxedUnit)MODULE$.logTime(new java.lang.StringBuilder(6).append("count ").append(tableIdentity).toString(), MODULE$.logTime$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration maxTime = Duration$.MODULE$.apply(config$1.getKylinConfig().getCountLookupTableMaxTime(), TimeUnit.MILLISECONDS);
            long defaultCount = config$1.getKylinConfig().getLookupTableCountDefaultValue();
            long rowCount = MODULE$.countTableInFiniteTimeOrDefault((Dataset<Row>)dataset, tableIdentity, (Duration)maxTime, defaultCount);
            TableMetaManager$.MODULE$.putTableMeta(tableIdentity, 0L, rowCount);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("put meta table: ").append(tableIdentity).append(" , count: ").append(rowCount).toString());
        });
    }

    private FlatTableStage$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.conf = KylinConfig.getInstanceFromEnv();
        this.inferFiltersEnabled = this.conf().inferFiltersEnabled();
    }
}

