/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.LayoutDataOptimizeJobHandler;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkLayoutDataOptimizeJob
extends DefaultExecutableOnModel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NSparkLayoutDataOptimizeJob.class);

    public NSparkLayoutDataOptimizeJob() {
    }

    public NSparkLayoutDataOptimizeJob(Object notSetId) {
        super(notSetId);
    }

    public static NSparkLayoutDataOptimizeJob create(LayoutDataOptimizeJobHandler.LayoutDataOptimizeJobParam jobBuildParams) {
        NSparkLayoutDataOptimizeJob job = new NSparkLayoutDataOptimizeJob();
        String project = jobBuildParams.getProject();
        String modelId = jobBuildParams.getModelId();
        String jobId = jobBuildParams.getJobId();
        job.setProject(project);
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataflow(modelId);
        job.setId(jobBuildParams.getJobId());
        job.setName(JobTypeEnum.LAYOUT_DATA_OPTIMIZE.toString());
        job.setJobType(JobTypeEnum.LAYOUT_DATA_OPTIMIZE);
        job.setTargetSubject(modelId);
        job.setId(jobId);
        job.setParam("layoutIds", NSparkCubingUtil.ids2Str((Set)NSparkCubingUtil.toLayoutIds((Set)jobBuildParams.getLayouts())));
        job.setParam("dataflowId", modelId);
        job.setParam("project", project);
        job.setParam("jobId", jobId);
        log.info("Create index data optimize job for {}.", (Object)modelId);
        StepEnum.RESOURCE_DETECT.create((DefaultExecutable)job, (KylinConfig)dataflow.getConfig());
        StepEnum.LAYOUT_DATA_OPTIMIZE.create((DefaultExecutable)job, (KylinConfig)dataflow.getConfig());
        return job;
    }

    public boolean checkSuicide() {
        return null == NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).getDataflow(this.getParam("dataflowId"));
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String dataflowId = this.getParam("dataflowId");
        return NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(dataflowId).collectPrecalculationResource();
    }

    static {
        JobFactory.register((String)"OPTIMIZE_JOB_FACTORY", (JobFactory)new LayoutDataOptimizeJobFactory());
    }

    static class LayoutDataOptimizeJobFactory
    extends JobFactory {
        private LayoutDataOptimizeJobFactory() {
        }

        protected NSparkLayoutDataOptimizeJob create(JobFactory.JobBuildParams jobBuildParams) {
            return NSparkLayoutDataOptimizeJob.create((LayoutDataOptimizeJobHandler.LayoutDataOptimizeJobParam)jobBuildParams);
        }
    }
}

