/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCleanupAfterMergeStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCleanupAfterMergeStep.class);

    public NSparkCleanupAfterMergeStep() {
        this.setName("Clean Up Old Segment");
    }

    public NSparkCleanupAfterMergeStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected ExecuteResult doWork(JobContext context) throws ExecuteException {
        String name = this.getParam("dataflowId");
        String[] segmentIds = StringUtils.split((String)this.getParam("segmentIds"), (String)",");
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(name);
        for (String segmentId : segmentIds) {
            String path = dataflow.getSegmentHdfsPath(segmentId);
            try {
                HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(path));
                logger.info("The segment {} in dataflow {} has been successfully deleted, path : {}", new Object[]{segmentId, name, path});
            }
            catch (IOException e) {
                logger.warn("Can not delete segment {} in dataflow {}. Please try workaround thru garbage clean manually.", new Object[]{segmentId, name, e});
            }
        }
        return ExecuteResult.createSucceed();
    }
}

