/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.engine.mr.streaming.ColumnarFilesReader;
import org.apache.kylin.engine.mr.streaming.RowRecord;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncodingFactory;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreDimDesc;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreMetricsDesc;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimensionMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.MetricMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowRecordReader
extends ColumnarFilesReader {
    private static final Logger logger = LoggerFactory.getLogger(RowRecordReader.class);
    private List<ColumnDataReader> dimensionColumnReaders;
    private List<ColumnDataReader> metricsColumnReaders;
    private List<Iterator<byte[]>> dimensionColumnReaderItrs;
    private List<Iterator<byte[]>> metricsColumnReaderItrs;
    private List<DimensionEncoding> dimensionEncodings;
    private List<MetricsDataTransformer> metricsDataTransformers;
    private CubeDesc cubeDesc;
    private String[] rowDimensionValues;
    private byte[][] rowMetricsValues;
    private RowRecord currentRowRecord;

    public RowRecordReader(CubeDesc cubeDesc, Path path, FileSystem fileSystem) throws IOException {
        super(fileSystem, path);
        this.cubeDesc = cubeDesc;
        this.folderPath = path;
        this.fs = fileSystem;
        this.currentRowRecord = new RowRecord();
        this.initReaders();
    }

    public void initReaders() throws IOException {
        FSDataInputStream in = this.fs.open(this.metaFilePath);
        FragmentMetaInfo fragmentMetaInfo = (FragmentMetaInfo)JsonUtil.readValue((InputStream)in, FragmentMetaInfo.class);
        CuboidMetaInfo basicCuboidMetaInfo = fragmentMetaInfo.getBasicCuboidMetaInfo();
        FSDataInputStream dictInputStream = this.fs.open(this.dataFilePath);
        List allDimensions = basicCuboidMetaInfo.getDimensionsInfo();
        Map<String, DimensionEncoding> dimensionEncodingMap = this.getDimensionEncodings(fragmentMetaInfo, allDimensions, dictInputStream);
        this.dimensionColumnReaders = Lists.newArrayList();
        this.dimensionColumnReaderItrs = Lists.newArrayList();
        this.dimensionEncodings = Lists.newArrayList();
        for (DimensionMetaInfo dimensionMetaInfo : allDimensions) {
            FSDataInputStream dimInputStream = this.fs.open(this.dataFilePath);
            String dimName = dimensionMetaInfo.getName();
            DimensionEncoding dimEncoding = dimensionEncodingMap.get(dimName);
            ColumnarStoreDimDesc dimDesc = new ColumnarStoreDimDesc(dimEncoding.getLengthOfEncoding(), dimensionMetaInfo.getCompressionType());
            ColumnDataReader dimDataReader = dimDesc.getDimReaderFromFSInput(dimInputStream, dimensionMetaInfo.getStartOffset(), dimensionMetaInfo.getDataLength(), (int)basicCuboidMetaInfo.getNumberOfRows());
            this.dimensionColumnReaders.add(dimDataReader);
            this.dimensionColumnReaderItrs.add(dimDataReader.iterator());
            this.dimensionEncodings.add(dimEncoding);
        }
        this.rowDimensionValues = new String[this.dimensionColumnReaders.size()];
        this.metricsColumnReaders = Lists.newArrayList();
        this.metricsColumnReaderItrs = Lists.newArrayList();
        this.metricsDataTransformers = Lists.newArrayList();
        for (MetricMetaInfo metricMetaInfo : basicCuboidMetaInfo.getMetricsInfo()) {
            FSDataInputStream metricsInputStream = this.fs.open(this.dataFilePath);
            MeasureDesc measure = this.findMeasure(metricMetaInfo.getName());
            DataType metricsDataType = measure.getFunction().getReturnDataType();
            ColumnarMetricsEncoding metricsEncoding = ColumnarMetricsEncodingFactory.create((DataType)metricsDataType);
            ColumnarStoreMetricsDesc metricsDesc = new ColumnarStoreMetricsDesc(metricsEncoding, metricMetaInfo.getCompressionType());
            ColumnDataReader metricsDataReader = metricsDesc.getMetricsReaderFromFSInput(metricsInputStream, metricMetaInfo.getStartOffset(), metricMetaInfo.getMetricLength(), (int)basicCuboidMetaInfo.getNumberOfRows());
            this.metricsColumnReaders.add(metricsDataReader);
            this.metricsColumnReaderItrs.add(metricsDataReader.iterator());
            this.metricsDataTransformers.add(new MetricsDataTransformer(metricsEncoding.asDataTypeSerializer(), DataTypeSerializer.create((DataType)metricsDataType)));
        }
        this.rowMetricsValues = new byte[this.metricsColumnReaders.size()][];
    }

    private MeasureDesc findMeasure(String name) {
        List measures = this.cubeDesc.getMeasures();
        for (MeasureDesc measure : measures) {
            if (!name.equals(measure.getName())) continue;
            return measure;
        }
        return null;
    }

    private Map<String, DimensionEncoding> getDimensionEncodings(FragmentMetaInfo fragmentMetaInfo, List<DimensionMetaInfo> allDimensions, FSDataInputStream dictInputStream) throws IOException {
        Map<String, Dictionary> dictionaryMap = this.readAllDimensionsDictionary(fragmentMetaInfo, dictInputStream);
        HashMap result = Maps.newHashMap();
        for (DimensionMetaInfo dimension : allDimensions) {
            TblColRef col = this.cubeDesc.getModel().findColumn(dimension.getName());
            RowKeyColDesc colDesc = this.cubeDesc.getRowkey().getColDesc(col);
            if (colDesc.isUsingDictionary()) {
                Dictionary dict = dictionaryMap.get(dimension.getName());
                if (dict == null) {
                    logger.error("No dictionary found for dict-encoding column " + col);
                    throw new RuntimeException("No dictionary found for dict-encoding column " + col);
                }
                result.put(dimension.getName(), new DictionaryDimEnc(dict));
                continue;
            }
            result.put(dimension.getName(), DimensionEncodingFactory.create((String)colDesc.getEncodingName(), (String[])colDesc.getEncodingArgs(), (int)colDesc.getEncodingVersion()));
        }
        return result;
    }

    public Map<String, Dictionary> readAllDimensionsDictionary(FragmentMetaInfo fragmentMetaInfo, FSDataInputStream dataInputStream) throws IOException {
        List dimDictMetaInfos = fragmentMetaInfo.getDimDictionaryMetaInfos();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DimDictionaryMetaInfo dimDictMetaInfo : dimDictMetaInfos) {
            dataInputStream.seek((long)dimDictMetaInfo.getStartOffset());
            Dictionary dict = DictionarySerializer.deserialize((InputStream)dataInputStream);
            String colName = dimDictMetaInfo.getDimName();
            builder.put((Object)colName, (Object)dict);
        }
        return builder.build();
    }

    public boolean hasNextRow() {
        if (this.hasNextDimensionsRow() && this.hasNextMetricsRow()) {
            this.currentRowRecord.setDimensions(this.rowDimensionValues);
            this.currentRowRecord.setMetrics(this.rowMetricsValues);
            return true;
        }
        return false;
    }

    public RowRecord nextRow() {
        return this.currentRowRecord;
    }

    private boolean hasNextDimensionsRow() {
        for (int i = 0; i < this.dimensionColumnReaders.size(); ++i) {
            Iterator<byte[]> itr = this.dimensionColumnReaderItrs.get(i);
            if (!itr.hasNext()) {
                return false;
            }
            byte[] colValue = itr.next();
            this.rowDimensionValues[i] = colValue == null ? null : this.dimensionEncodings.get(i).decode(colValue, 0, colValue.length);
        }
        return true;
    }

    private boolean hasNextMetricsRow() {
        for (int i = 0; i < this.metricsColumnReaders.size(); ++i) {
            Iterator<byte[]> itr = this.metricsColumnReaderItrs.get(i);
            if (!itr.hasNext()) {
                return false;
            }
            byte[] colValue = itr.next();
            this.rowMetricsValues[i] = (byte[])(colValue == null ? null : this.metricsDataTransformers.get(i).transformFromColumnarMetrics(colValue));
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        for (ColumnDataReader dimensionColumnReader : this.dimensionColumnReaders) {
            dimensionColumnReader.close();
        }
        for (ColumnDataReader metricsColumnReader : this.metricsColumnReaders) {
            metricsColumnReader.close();
        }
    }

    public static class MetricsDataTransformer {
        private DataTypeSerializer columnarMetricsSerializer;
        private DataTypeSerializer rowBasedMetricsSerializer;
        private boolean isSame = false;
        private ByteBuffer byteBuffer;

        public MetricsDataTransformer(DataTypeSerializer columnarMetricsSerializer, DataTypeSerializer rowBasedMetricsSerializer) {
            this.columnarMetricsSerializer = columnarMetricsSerializer;
            this.rowBasedMetricsSerializer = rowBasedMetricsSerializer;
            if (columnarMetricsSerializer.getClass() == rowBasedMetricsSerializer.getClass()) {
                this.isSame = true;
            } else {
                this.byteBuffer = ByteBuffer.allocate(rowBasedMetricsSerializer.maxLength());
            }
        }

        public byte[] transformFromColumnarMetrics(byte[] metricsValue) {
            if (this.isSame) {
                return metricsValue;
            }
            this.byteBuffer.clear();
            Object val = this.columnarMetricsSerializer.deserialize(ByteBuffer.wrap(metricsValue));
            this.rowBasedMetricsSerializer.serialize(val, this.byteBuffer);
            return Arrays.copyOf(this.byteBuffer.array(), this.byteBuffer.position());
        }
    }
}

