/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.engine.mr.streaming.ColumnarFilesReader;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictsReader
extends ColumnarFilesReader {
    private static final Logger logger = LoggerFactory.getLogger(DictsReader.class);
    private FSDataInputStream metaInputStream;
    private FSDataInputStream dataInputStream;

    public DictsReader(Path path, FileSystem fileSystem) throws IOException {
        super(fileSystem, path);
    }

    public ImmutableMap<String, Dictionary> readDicts() throws IOException {
        this.metaInputStream = this.fs.open(this.metaFilePath);
        FragmentMetaInfo fragmentMetaInfo = (FragmentMetaInfo)JsonUtil.readValue((InputStream)this.metaInputStream, FragmentMetaInfo.class);
        List dimDictMetaInfos = fragmentMetaInfo.getDimDictionaryMetaInfos();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.dataInputStream = this.fs.open(this.dataFilePath);
        logger.info("Reading dictionary from {}", (Object)this.dataFilePath.getName());
        for (DimDictionaryMetaInfo dimDictMetaInfo : dimDictMetaInfos) {
            this.dataInputStream.seek((long)dimDictMetaInfo.getStartOffset());
            Dictionary dict = DictionarySerializer.deserialize((InputStream)this.dataInputStream);
            String colName = dimDictMetaInfo.getDimName();
            logger.info("Add dict for {}", (Object)colName);
            builder.put((Object)colName, (Object)dict);
        }
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.metaInputStream != null) {
                this.metaInputStream.close();
            }
            if (this.dataInputStream != null) {
                this.dataInputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("close file error", (Throwable)e);
        }
    }
}

