/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.metadata.model.MeasureDesc;

public class ColumnToRowReducer
extends KylinReducer<Text, Text, Text, Text> {
    private String cubeName;
    private CubeDesc cubeDesc;
    private CubeInstance cube;
    private List<MeasureDesc> measures;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException, InterruptedException {
        super.doSetup(context);
        Configuration conf = context.getConfiguration();
        this.cubeName = conf.get("cube.name");
        if (this.cubeName == null) {
            throw new IllegalArgumentException("Can not find cube. ");
        }
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cube = CubeManager.getInstance((KylinConfig)config).getCube(this.cubeName.toUpperCase(Locale.ROOT));
        this.cubeDesc = this.cube.getDescriptor();
        this.measures = this.cubeDesc.getMeasures();
    }

    @Override
    protected void doReduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        context.write((Object)key, (Object)this.mergeRecord(values));
    }

    private Text mergeRecord(Iterable<Text> values) {
        Object[] aggResult = new Object[this.measures.size()];
        Iterator<Text> iterator = values.iterator();
        BufferedMeasureCodec codec = new BufferedMeasureCodec(this.measures);
        MeasureAggregators aggregators = new MeasureAggregators(this.measures);
        Object[] metrics = new Object[this.measures.size()];
        while (iterator.hasNext()) {
            byte[] bytes = iterator.next().getBytes();
            codec.decode(ByteBuffer.wrap(bytes), metrics);
            aggregators.aggregate(metrics);
        }
        aggregators.collectStates(aggResult);
        ByteBuffer valueBuffer = codec.encode(aggResult);
        Text result = new Text();
        result.set(valueBuffer.array(), 0, valueBuffer.position());
        return result;
    }
}

