/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateOldCuboidShardMapper
extends KylinMapper<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(UpdateOldCuboidShardMapper.class);
    private CubeDesc cubeDesc;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private Text outputKey = new Text();
    private byte[] newKeyBodyBuf = new byte[16640];
    private ByteArray newKeyBuf = ByteArray.allocate((int)16640);

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        String cubeName = context.getConfiguration().get("cube.name");
        String segmentID = context.getConfiguration().get("cube.segment.id");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(cubeName);
        CubeSegment cubeSegment = cube.getSegmentById(segmentID);
        CubeSegment oldSegment = cube.getOriginalSegmentToOptimize(cubeSegment);
        this.cubeDesc = cube.getDescriptor();
        this.rowKeySplitter = new RowKeySplitter(oldSegment);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(cubeSegment);
    }

    @Override
    public void doMap(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        long cuboidID = this.rowKeySplitter.split(key.getBytes());
        Cuboid cuboid = Cuboid.findForMandatory((CubeDesc)this.cubeDesc, (long)cuboidID);
        int fullKeySize = this.buildKey(cuboid, this.rowKeySplitter.getSplitBuffers());
        this.outputKey.set(this.newKeyBuf.array(), 0, fullKeySize);
        context.write((Object)this.outputKey, (Object)value);
    }

    private int buildKey(Cuboid cuboid, ByteArray[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(cuboid);
        int startIdx = this.rowKeySplitter.getBodySplitOffset();
        int endIdx = startIdx + Long.bitCount(cuboid.getId());
        int offset = 0;
        for (int i = startIdx; i < endIdx; ++i) {
            System.arraycopy(splitBuffers[i].array(), splitBuffers[i].offset(), this.newKeyBodyBuf, offset, splitBuffers[i].length());
            offset += splitBuffers[i].length();
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf = new ByteArray(this.newKeyBuf.length() * 2);
        }
        this.newKeyBuf.setLength(fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, offset), this.newKeyBuf);
        return fullKeySize;
    }
}

