/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.apache.kylin.engine.mr.steps.UHCDictionaryMapper;
import org.apache.kylin.engine.mr.steps.UHCDictionaryPartitioner;
import org.apache.kylin.engine.mr.steps.UHCDictionaryReducer;
import org.apache.kylin.engine.mr.steps.filter.UHCDictPathFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UHCDictionaryJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(UHCDictionaryJob.class);
    private boolean isSkipped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_INPUT_PATH);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String job_id = this.getOptionValue(OPTION_CUBING_JOB_ID);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            List uhcColumns = cube.getDescriptor().getAllUHCColumns();
            int reducerCount = uhcColumns.size();
            boolean hasUHCValue = false;
            for (TblColRef tblColRef : uhcColumns) {
                Path path = new Path(input.toString() + "/" + tblColRef.getIdentity());
                if (!HadoopUtil.getFileSystem((Path)path).exists(path)) continue;
                FileInputFormat.addInputPath((Job)this.job, (Path)path);
                FileInputFormat.setInputPathFilter((Job)this.job, UHCDictPathFilter.class);
                hasUHCValue = true;
            }
            if (!hasUHCValue) {
                this.isSkipped = true;
                int n = 0;
                return n;
            }
            this.setJobClasspath(this.job, cube.getConfig());
            this.setupMapper();
            this.setupReducer(output, reducerCount);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cubingJobId", job_id);
            this.job.getConfiguration().set("global.dict.base.dir", KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
            this.job.getConfiguration().set("mapred.output.compress", "false");
            this.job.getConfiguration().set("mapreduce.reduce.memory.mb", "8500");
            this.job.getConfiguration().set("mapred.reduce.child.java.opts", "-Xmx8g");
            this.job.getConfiguration().set("mapreduce.task.timeout", "28800000");
            for (Map.Entry entry : cube.getConfig().getUHCMRConfigOverride().entrySet()) {
                this.job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
            }
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setupMapper() throws IOException {
        this.job.setInputFormatClass(SequenceFileInputFormat.class);
        this.job.setMapperClass(UHCDictionaryMapper.class);
        this.job.setMapOutputKeyClass(SelfDefineSortableKey.class);
        this.job.setMapOutputValueClass(NullWritable.class);
    }

    private void setupReducer(Path output, int numberOfReducers) throws IOException {
        this.job.setReducerClass(UHCDictionaryReducer.class);
        this.job.setPartitionerClass(UHCDictionaryPartitioner.class);
        this.job.setNumReduceTasks(numberOfReducers);
        MultipleOutputs.addNamedOutput((Job)this.job, (String)"dict", SequenceFileOutputFormat.class, NullWritable.class, ArrayPrimitiveWritable.class);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
        this.job.getConfiguration().set("output.path", output.toString());
        LazyOutputFormat.setOutputFormatClass((Job)this.job, SequenceFileOutputFormat.class);
        this.deletePath(this.job.getConfiguration(), output);
    }

    @Override
    public boolean isSkipped() {
        return this.isSkipped;
    }

    public static void main(String[] args) throws Exception {
        UHCDictionaryJob job = new UHCDictionaryJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

