/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.mr.common.StatisticsDecisionUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveStatisticsStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SaveStatisticsStep.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeSegment newSegment = CubingExecutableUtil.findSegment(context, CubingExecutableUtil.getCubeName(this.getParams()), CubingExecutableUtil.getSegmentId(this.getParams()));
        KylinConfig kylinConf = newSegment.getConfig();
        ResourceStore rs = ResourceStore.getStore((KylinConfig)kylinConf);
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Configuration hadoopConf = HadoopUtil.getCurrentConfiguration();
            Path statisticsDir = new Path(CubingExecutableUtil.getStatisticsPath(this.getParams()));
            Path[] statisticsFiles = HadoopUtil.getFilteredPath((FileSystem)fs, (Path)statisticsDir, (String)"statistics");
            if (statisticsFiles == null) {
                throw new IOException("fail to find the statistics file in base dir: " + statisticsDir);
            }
            HashMap cuboidHLLMap = Maps.newHashMap();
            long totalRowsBeforeMerge = 0L;
            long grantTotal = 0L;
            int samplingPercentage = -1;
            int mapperNumber = -1;
            for (Path item : statisticsFiles) {
                CubeStatsReader.CubeStatsResult cubeStatsResult = new CubeStatsReader.CubeStatsResult(item, kylinConf.getCubeStatsHLLPrecision());
                cuboidHLLMap.putAll(cubeStatsResult.getCounterMap());
                long pGrantTotal = 0L;
                for (HLLCounter hll : cubeStatsResult.getCounterMap().values()) {
                    pGrantTotal += hll.getCountEstimate();
                }
                totalRowsBeforeMerge = (long)((double)totalRowsBeforeMerge + (double)pGrantTotal * cubeStatsResult.getMapperOverlapRatio());
                grantTotal += pGrantTotal;
                int pMapperNumber = cubeStatsResult.getMapperNumber();
                if (pMapperNumber > 0) {
                    if (mapperNumber < 0) {
                        mapperNumber = pMapperNumber;
                    } else {
                        throw new RuntimeException("Base cuboid has been distributed to multiple reducers at step FactDistinctColumnsReducer!!!");
                    }
                }
                int pSamplingPercentage = cubeStatsResult.getPercentage();
                if (samplingPercentage < 0) {
                    samplingPercentage = pSamplingPercentage;
                    continue;
                }
                if (samplingPercentage == pSamplingPercentage) continue;
                throw new RuntimeException("The sampling percentage should be same among all of the reducer of FactDistinctColumnsReducer!!!");
            }
            if (samplingPercentage < 0) {
                logger.warn("The sampling percentage should be set!!!");
            }
            if (mapperNumber < 0) {
                logger.warn("The mapper number should be set!!!");
            }
            if (logger.isDebugEnabled()) {
                this.logMapperAndCuboidStatistics(cuboidHLLMap, samplingPercentage, mapperNumber, grantTotal, totalRowsBeforeMerge);
            }
            double mapperOverlapRatio = grantTotal == 0L ? 0.0 : (double)totalRowsBeforeMerge / (double)grantTotal;
            CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
            long sourceRecordCount = cubingJob.findSourceRecordCount();
            CubeStatsWriter.writeCuboidStatistics(hadoopConf, statisticsDir, cuboidHLLMap, samplingPercentage, mapperNumber, mapperOverlapRatio, sourceRecordCount);
            Path statisticsFile = new Path(statisticsDir, "cuboid_statistics.seq");
            logger.info("{} stats saved to hdfs {}", (Object)newSegment, (Object)statisticsFile);
            FSDataInputStream is = fs.open(statisticsFile);
            try {
                String resPath = newSegment.getStatisticsResourcePath();
                rs.putResource(resPath, (InputStream)is, System.currentTimeMillis());
                logger.info("{} stats saved to resource {}", (Object)newSegment, (Object)resPath);
                StatisticsDecisionUtil.decideCubingAlgorithm(cubingJob, newSegment);
                StatisticsDecisionUtil.optimizeCubingPlan(newSegment);
            }
            finally {
                IOUtils.closeStream((Closeable)is);
            }
            return ExecuteResult.createSucceed();
        }
        catch (IOException e) {
            logger.error("fail to save cuboid statistics", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
    }

    private void logMapperAndCuboidStatistics(Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, int mapperNumber, long grantTotal, long totalRowsBeforeMerge) {
        logger.debug("Total cuboid number: \t" + cuboidHLLMap.size());
        logger.debug("Sampling percentage: \t" + samplingPercentage);
        logger.debug("The following statistics are collected based on sampling data.");
        logger.debug("Number of Mappers: " + mapperNumber);
        ArrayList allCuboids = Lists.newArrayList(cuboidHLLMap.keySet());
        Collections.sort(allCuboids);
        Iterator iterator = allCuboids.iterator();
        while (iterator.hasNext()) {
            long i = (Long)iterator.next();
            logger.debug("Cuboid " + i + " row count is: \t " + cuboidHLLMap.get(i).getCountEstimate());
        }
        logger.debug("Sum of all the cube segments (before merge) is: \t " + totalRowsBeforeMerge);
        logger.debug("After merge, the cube has row count: \t " + grantTotal);
        if (grantTotal > 0L) {
            logger.debug("The mapper overlap ratio is: \t" + (double)totalRowsBeforeMerge / (double)grantTotal);
        }
    }
}

