/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class FactDistinctColumnsReducerMapping {
    public static final int MARK_FOR_HLL_COUNTER = -1;
    private final int nCuboidRowCounters;
    private final int nDimReducers;
    private final int nTotalReducers;
    private final List<TblColRef> allDimDictCols = Lists.newArrayList();
    private final int[] colIdToReducerBeginId;
    private final int[] reducerRolePlay;

    public FactDistinctColumnsReducerMapping(CubeInstance cube) {
        this(cube, 0);
    }

    private FactDistinctColumnsReducerMapping(CubeInstance cube, int cuboidRowCounterReducerNum) {
        int i;
        CubeDesc desc = cube.getDescriptor();
        Set allCols = cube.getAllColumns();
        Set dictCols = desc.getAllColumnsNeedDictionaryBuilt();
        List dimCols = desc.listDimensionColumnsExcludingDerived(true);
        for (TblColRef colRef : allCols) {
            if (dictCols.contains(colRef)) {
                this.allDimDictCols.add(colRef);
                continue;
            }
            if (dimCols.indexOf(colRef) < 0) continue;
            this.allDimDictCols.add(colRef);
        }
        this.colIdToReducerBeginId = new int[this.allDimDictCols.size() + 1];
        int uhcReducerCount = cube.getConfig().getUHCReducerCount();
        List uhcList = desc.getAllUHCColumns();
        int counter = 0;
        for (i = 0; i < this.allDimDictCols.size(); ++i) {
            this.colIdToReducerBeginId[i] = counter;
            boolean isUHC = uhcList.contains(this.allDimDictCols.get(i));
            counter += isUHC ? uhcReducerCount : 1;
        }
        this.colIdToReducerBeginId[this.allDimDictCols.size()] = counter;
        this.nDimReducers = counter;
        this.nCuboidRowCounters = cuboidRowCounterReducerNum == 0 ? MapReduceUtil.getCuboidHLLCounterReducerNum(cube) : cuboidRowCounterReducerNum;
        this.nTotalReducers = this.nDimReducers + this.nCuboidRowCounters;
        this.reducerRolePlay = new int[this.nTotalReducers];
        int dictId = 0;
        for (i = 0; i < this.nTotalReducers; ++i) {
            if (i >= this.nDimReducers) {
                this.reducerRolePlay[i] = -1;
                continue;
            }
            if (i == this.colIdToReducerBeginId[dictId + 1]) {
                // empty if block
            }
            this.reducerRolePlay[i] = ++dictId;
        }
    }

    public List<TblColRef> getAllDimDictCols() {
        return this.allDimDictCols;
    }

    public int getTotalReducerNum() {
        return this.nTotalReducers;
    }

    public int getCuboidRowCounterReducerNum() {
        return this.nCuboidRowCounters;
    }

    public int getReducerIdForCol(int colId, Object fieldValue) {
        int begin = this.colIdToReducerBeginId[colId];
        int span = this.colIdToReducerBeginId[colId + 1] - begin;
        if (span == 1) {
            return begin;
        }
        int hash = fieldValue == null ? 0 : fieldValue.hashCode();
        return begin + Math.abs(hash % span);
    }

    public int[] getAllRolePlaysForReducers() {
        return this.reducerRolePlay;
    }

    public int getRolePlayOfReducer(int reducerId) {
        return this.reducerRolePlay[reducerId % this.nTotalReducers];
    }

    public boolean isCuboidRowCounterReducer(int reducerId) {
        return this.getRolePlayOfReducer(reducerId) == -1;
    }

    public TblColRef getColForReducer(int reducerId) {
        int role = this.getRolePlayOfReducer(reducerId % this.nTotalReducers);
        if (role < 0) {
            throw new IllegalStateException();
        }
        return this.allDimDictCols.get(role);
    }

    public int getReducerNumForDimCol(TblColRef col) {
        int dictColId = this.allDimDictCols.indexOf(col);
        return this.colIdToReducerBeginId[dictColId + 1] - this.colIdToReducerBeginId[dictColId];
    }

    public int getReducerIdForCuboidRowCount(long cuboidId) {
        int rowCounterId = (int)(Math.abs(cuboidId) % (long)this.nCuboidRowCounters);
        return this.nDimReducers + rowCounterId;
    }
}

