/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducerMapping;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.apache.kylin.metadata.model.TblColRef;

public abstract class FactDistinctColumnsMapperBase<KEYIN, VALUEIN>
extends KylinMapper<KEYIN, VALUEIN, SelfDefineSortableKey, Text> {
    protected String cubeName;
    protected CubeInstance cube;
    protected CubeSegment cubeSeg;
    protected CubeDesc cubeDesc;
    protected long baseCuboidId;
    protected IMRInput.IMRTableInputFormat flatTableInputFormat;
    protected List<TblColRef> allCols;
    protected Text outputKey = new Text();
    protected Text outputValue = new Text();
    protected int errorRecordCounter = 0;
    protected CubeJoinedFlatTableEnrich intermediateTableDesc;
    protected int[] columnIndex;
    protected FactDistinctColumnsReducerMapping reducerMapping;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.bindCurrentConfiguration(conf);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeName = conf.get("cube.name");
        this.cube = CubeManager.getInstance((KylinConfig)config).getCube(this.cubeName);
        this.cubeSeg = this.cube.getSegmentById(conf.get("cube.segment.id"));
        this.cubeDesc = this.cube.getDescriptor();
        this.baseCuboidId = Cuboid.getBaseCuboidId((CubeDesc)this.cubeDesc);
        this.reducerMapping = new FactDistinctColumnsReducerMapping(this.cube);
        this.allCols = this.reducerMapping.getAllDimDictCols();
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(this.cubeSeg).getFlatTableInputFormat();
        this.intermediateTableDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.cubeSeg), this.cubeDesc);
        this.columnIndex = new int[this.allCols.size()];
        for (int i = 0; i < this.allCols.size(); ++i) {
            int columnIndexOnFlatTbl;
            TblColRef colRef = this.allCols.get(i);
            this.columnIndex[i] = columnIndexOnFlatTbl = this.intermediateTableDesc.getColumnIndex(colRef);
        }
    }

    protected void handleErrorRecord(String[] record, Exception ex) throws IOException {
        System.err.println("Insane record: " + Arrays.toString(record));
        ex.printStackTrace(System.err);
        ++this.errorRecordCounter;
        if (this.errorRecordCounter > this.cubeSeg.getConfig().getErrorRecordThreshold()) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("", ex);
        }
    }
}

