/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayPrimitiveWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnPartitioner;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsCombiner;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapper;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducer;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsReducerMapping;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactDistinctColumnsJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(FactDistinctColumnsJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_CUBING_JOB_ID);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_STATISTICS_OUTPUT);
            options.addOption(OPTION_STATISTICS_SAMPLING_PERCENT);
            this.parseOptions(options, args);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String job_id = this.getOptionValue(OPTION_CUBING_JOB_ID);
            this.job.getConfiguration().set("cubingJobId", job_id);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            String statistics_output = this.getOptionValue(OPTION_STATISTICS_OUTPUT);
            String statistics_sampling_percent = this.getOptionValue(OPTION_STATISTICS_SAMPLING_PERCENT);
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            if (segment == null) {
                logger.warn("Failed to find segment {} in cube {}", (Object)segmentID, (Object)cube);
                cube = cubeMgr.reloadCubeQuietly(cubeName);
                segment = cube.getSegmentById(segmentID);
            }
            if (segment == null) {
                logger.error("Failed to find {} in cube {}", (Object)segmentID, (Object)cube);
                for (CubeSegment s : cube.getSegments()) {
                    logger.error(s.getName() + " with status " + s.getStatus());
                }
                throw new IllegalStateException();
            }
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().set("statistics.ouput", statistics_output);
            this.job.getConfiguration().set("statistics.sampling.percent", statistics_sampling_percent);
            logger.info("Starting: " + this.job.getJobName());
            this.setJobClasspath(this.job, cube.getConfig());
            this.setupMapper(segment);
            this.setupReducer(output, segment);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
            this.job.getConfiguration().set("mapred.output.compress", "false");
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setupMapper(CubeSegment cubeSeg) throws IOException {
        IMRInput.IMRTableInputFormat flatTableInputFormat = MRUtil.getBatchCubingInputSide(cubeSeg).getFlatTableInputFormat();
        flatTableInputFormat.configureJob(this.job);
        this.job.setMapperClass(FactDistinctColumnsMapper.class);
        this.job.setCombinerClass(FactDistinctColumnsCombiner.class);
        this.job.setMapOutputKeyClass(SelfDefineSortableKey.class);
        this.job.setMapOutputValueClass(Text.class);
    }

    private void setupReducer(Path output, CubeSegment cubeSeg) throws IOException {
        FactDistinctColumnsReducerMapping reducerMapping = new FactDistinctColumnsReducerMapping(cubeSeg.getCubeInstance());
        int numberOfReducers = reducerMapping.getTotalReducerNum();
        logger.info("{} has reducers {}.", (Object)((Object)((Object)this)).getClass().getName(), (Object)numberOfReducers);
        if (numberOfReducers > 250) {
            throw new IllegalArgumentException("The max reducer number for FactDistinctColumnsJob is 250, but now it is " + numberOfReducers + ", decrease 'kylin.engine.mr.uhc-reducer-count'");
        }
        this.job.setReducerClass(FactDistinctColumnsReducer.class);
        this.job.setPartitionerClass(FactDistinctColumnPartitioner.class);
        this.job.setNumReduceTasks(numberOfReducers);
        MultipleOutputs.addNamedOutput((Job)this.job, (String)"column", SequenceFileOutputFormat.class, NullWritable.class, Text.class);
        MultipleOutputs.addNamedOutput((Job)this.job, (String)"dict", SequenceFileOutputFormat.class, NullWritable.class, ArrayPrimitiveWritable.class);
        MultipleOutputs.addNamedOutput((Job)this.job, (String)"statistics", SequenceFileOutputFormat.class, LongWritable.class, BytesWritable.class);
        MultipleOutputs.addNamedOutput((Job)this.job, (String)"partition", TextOutputFormat.class, NullWritable.class, LongWritable.class);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
        this.job.getConfiguration().set("output.path", output.toString());
        LazyOutputFormat.setOutputFormatClass((Job)this.job, SequenceFileOutputFormat.class);
        this.deletePath(this.job.getConfiguration(), output);
    }

    public static void main(String[] args) throws Exception {
        FactDistinctColumnsJob job = new FactDistinctColumnsJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

