/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDictionaryStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(CopyDictionaryStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager mgr = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams())).latestCopyForWrite();
        CubeSegment optimizeSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubeSegment oldSegment = optimizeSegment.getCubeInstance().getOriginalSegmentToOptimize(optimizeSegment);
        Preconditions.checkNotNull((Object)oldSegment, (Object)("cannot find the original segment to be optimized by " + optimizeSegment));
        optimizeSegment.getDictionaries().putAll(oldSegment.getDictionaries());
        optimizeSegment.getSnapshots().putAll(oldSegment.getSnapshots());
        optimizeSegment.getRowkeyStats().addAll(oldSegment.getRowkeyStats());
        try {
            CubeUpdate cubeBuilder = new CubeUpdate(cube);
            cubeBuilder.setToUpdateSegs(new CubeSegment[]{optimizeSegment});
            mgr.updateCube(cubeBuilder);
        }
        catch (IOException e) {
            logger.error("fail to merge dictionary or lookup snapshots", (Throwable)e);
            return ExecuteResult.createError((Throwable)e);
        }
        return new ExecuteResult();
    }
}

