/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;

public class ConvergeCuboidDataReducer
extends KylinReducer<Text, Text, Text, Text> {
    private MultipleOutputs mos;
    private boolean enableSharding;
    private long baseCuboid;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        this.mos = new MultipleOutputs((TaskInputOutputContext)context);
        String cubeName = context.getConfiguration().get("cube.name");
        String segmentID = context.getConfiguration().get("cube.segment.id");
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(cubeName);
        CubeSegment cubeSegment = cube.getSegmentById(segmentID);
        CubeSegment oldSegment = cube.getOriginalSegmentToOptimize(cubeSegment);
        this.enableSharding = oldSegment.isEnableSharding();
        this.baseCuboid = cube.getCuboidScheduler().getBaseCuboidId();
    }

    @Override
    public void doReduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        long cuboidID = RowKeySplitter.getCuboidId((byte[])key.getBytes(), (boolean)this.enableSharding);
        String baseOutputPath = cuboidID == this.baseCuboid ? "base_cuboid" : "old";
        int n = 0;
        for (Text value : values) {
            this.mos.write((Object)key, (Object)value, this.generateFileName(baseOutputPath));
            ++n;
        }
        if (n > 1) {
            throw new RuntimeException("multiple records share the same key in aggregated cuboid data for cuboid " + cuboidID);
        }
    }

    @Override
    public void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
        this.mos.close();
        Path outputDirBase = new Path(context.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir"), "base_cuboid");
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        if (!fs.exists(outputDirBase)) {
            fs.mkdirs(outputDirBase);
            SequenceFile.createWriter((Configuration)context.getConfiguration(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(outputDirBase, "part-m-00000")), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)}).close();
        }
    }

    private String generateFileName(String subDir) {
        return subDir + "/part";
    }
}

