/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.kylin.common.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateStatsFromBaseCuboidPartitioner
extends Partitioner<Text, Text>
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(CalculateStatsFromBaseCuboidPartitioner.class);
    private Configuration conf;
    private int hllShardBase = 1;

    public int getPartition(Text key, Text value, int numReduceTasks) {
        Long cuboidId = Bytes.toLong((byte[])key.getBytes());
        int shard = cuboidId.hashCode() % this.hllShardBase;
        if (shard < 0) {
            shard += this.hllShardBase;
        }
        return numReduceTasks - shard - 1;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.hllShardBase = conf.getInt("cuboidHLLCounterReducerNum", 1);
        logger.info("shard base for hll is " + this.hllShardBase);
    }

    public Configuration getConf() {
        return this.conf;
    }
}

