/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.MapReduceUtil;
import org.apache.kylin.engine.mr.steps.ConvergeCuboidDataPartitioner;
import org.apache.kylin.engine.mr.steps.ConvergeCuboidDataReducer;

public class ConvergeCuboidDataUtil {
    public static void setupReducer(Job job, CubeSegment cubeSegment, Path output) throws IOException {
        LazyOutputFormat.setOutputFormatClass((Job)job, SequenceFileOutputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)output);
        job.setReducerClass(ConvergeCuboidDataReducer.class);
        job.setPartitionerClass(ConvergeCuboidDataPartitioner.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        Pair<Integer, Integer> numReduceTasks = MapReduceUtil.getConvergeCuboidDataReduceTaskNums(cubeSegment);
        job.setNumReduceTasks(((Integer)numReduceTasks.getFirst()).intValue());
        int nBaseReduceTasks = (Integer)numReduceTasks.getSecond();
        boolean enableSharding = cubeSegment.isEnableSharding();
        long baseCuboidId = cubeSegment.getCuboidScheduler().getBaseCuboidId();
        String partiParams = enableSharding + "," + baseCuboidId + "," + nBaseReduceTasks;
        job.getConfiguration().set("converge.cuboid.partition.param", partiParams);
    }
}

