/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.kylin.metadata.datatype.DataType;

public class SelfDefineSortableKey
implements WritableComparable<SelfDefineSortableKey> {
    private byte typeId;
    private Text rawKey;
    private Object keyInObj;

    public SelfDefineSortableKey() {
    }

    public SelfDefineSortableKey(Text key, DataType type) {
        this.init(key, this.getTypeIdByDatatype(type));
    }

    public void init(Text key, byte typeId) {
        this.typeId = typeId;
        this.rawKey = key;
        if (this.isNumberFamily()) {
            String valueStr = new String(key.getBytes(), 1, key.getLength() - 1);
            this.keyInObj = this.isIntegerFamily() ? (Number)Long.parseLong(valueStr) : (Number)Double.parseDouble(valueStr);
        } else {
            this.keyInObj = key;
        }
    }

    public void init(Text key, DataType type) {
        this.init(key, this.getTypeIdByDatatype(type));
    }

    public int compareTo(SelfDefineSortableKey o) {
        if (this.typeId != o.typeId) {
            throw new IllegalStateException("Error. Incompatible types");
        }
        if (!this.isNumberFamily()) {
            return ((Text)this.keyInObj).compareTo((BinaryComparable)((Text)o.keyInObj));
        }
        if (this.isIntegerFamily()) {
            return Long.compare((Long)this.keyInObj, (Long)o.keyInObj);
        }
        return Double.compare((Double)this.keyInObj, (Double)o.keyInObj);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.typeId);
        this.rawKey.write(dataOutput);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.typeId = dataInput.readByte();
        Text inputKey = new Text();
        inputKey.readFields(dataInput);
        this.init(inputKey, this.typeId);
    }

    public short getTypeId() {
        return this.typeId;
    }

    public Text getText() {
        return this.rawKey;
    }

    public boolean isNumberFamily() {
        return this.typeId != TypeFlag.NONE_NUMERIC_TYPE.ordinal();
    }

    public boolean isIntegerFamily() {
        return this.typeId == TypeFlag.INTEGER_FAMILY_TYPE.ordinal();
    }

    public byte getTypeIdByDatatype(DataType type) {
        if (!type.isNumberFamily()) {
            return (byte)TypeFlag.NONE_NUMERIC_TYPE.ordinal();
        }
        if (type.isIntegerFamily()) {
            return (byte)TypeFlag.INTEGER_FAMILY_TYPE.ordinal();
        }
        return (byte)TypeFlag.DOUBLE_FAMILY_TYPE.ordinal();
    }

    public void setTypeId(byte typeId) {
        this.typeId = typeId;
    }

    public static enum TypeFlag {
        NONE_NUMERIC_TYPE,
        INTEGER_FAMILY_TYPE,
        DOUBLE_FAMILY_TYPE;

    }
}

