/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveStatisticsStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SaveStatisticsStep.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeSegment newSegment = CubingExecutableUtil.findSegment(context, CubingExecutableUtil.getCubeName(this.getParams()), CubingExecutableUtil.getSegmentId(this.getParams()));
        KylinConfig kylinConf = newSegment.getConfig();
        ResourceStore rs = ResourceStore.getStore((KylinConfig)kylinConf);
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path statisticsDir = new Path(CubingExecutableUtil.getStatisticsPath(this.getParams()));
            Path statisticsFilePath = HadoopUtil.getFilterOnlyPath((FileSystem)fs, (Path)statisticsDir, (String)"statistics");
            if (statisticsFilePath == null) {
                throw new IOException("fail to find the statistics file in base dir: " + statisticsDir);
            }
            FSDataInputStream is = fs.open(statisticsFilePath);
            try {
                String statisticsFileName = newSegment.getStatisticsResourcePath();
                rs.putResource(statisticsFileName, (InputStream)is, System.currentTimeMillis());
            }
            finally {
                IOUtils.closeStream((Closeable)is);
            }
            this.decideCubingAlgorithm(newSegment, kylinConf);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, "succeed");
        }
        catch (IOException e) {
            logger.error("fail to save cuboid statistics", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    private void decideCubingAlgorithm(CubeSegment seg, KylinConfig kylinConf) throws IOException {
        CubingJob.AlgorithmEnum alg;
        String algPref = kylinConf.getCubeAlgorithm();
        if (CubingJob.AlgorithmEnum.INMEM.name().equalsIgnoreCase(algPref)) {
            alg = CubingJob.AlgorithmEnum.INMEM;
        } else if (CubingJob.AlgorithmEnum.LAYER.name().equalsIgnoreCase(algPref)) {
            alg = CubingJob.AlgorithmEnum.LAYER;
        } else {
            int memoryHungryMeasures = 0;
            for (MeasureDesc measure : seg.getCubeDesc().getMeasures()) {
                if (!measure.getFunction().getMeasureType().isMemoryHungry()) continue;
                logger.info("This cube has memory-hungry measure " + measure.getFunction().getExpression());
                ++memoryHungryMeasures;
            }
            if (memoryHungryMeasures > 0) {
                alg = CubingJob.AlgorithmEnum.LAYER;
            } else if ("random".equalsIgnoreCase(algPref)) {
                alg = new Random().nextBoolean() ? CubingJob.AlgorithmEnum.INMEM : CubingJob.AlgorithmEnum.LAYER;
            } else {
                CubeStatsReader cubeStats = new CubeStatsReader(seg, kylinConf);
                int mapperNumber = cubeStats.getMapperNumberOfFirstBuild();
                int mapperNumLimit = kylinConf.getCubeAlgorithmAutoMapperLimit();
                double mapperOverlapRatio = cubeStats.getMapperOverlapRatioOfFirstBuild();
                double overlapThreshold = kylinConf.getCubeAlgorithmAutoThreshold();
                logger.info("mapperNumber for " + seg + " is " + mapperNumber + " and threshold is " + mapperNumLimit);
                logger.info("mapperOverlapRatio for " + seg + " is " + mapperOverlapRatio + " and threshold is " + overlapThreshold);
                alg = mapperNumber <= mapperNumLimit && mapperOverlapRatio <= overlapThreshold ? CubingJob.AlgorithmEnum.INMEM : CubingJob.AlgorithmEnum.LAYER;
            }
        }
        logger.info("The cube algorithm for " + seg + " is " + (Object)((Object)alg));
        CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
        cubingJob.setAlgorithm(alg);
    }
}

