/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.steps.CuboidJob;
import org.apache.kylin.engine.mr.steps.CuboidReducer;
import org.apache.kylin.engine.mr.steps.LayerReducerNumSizing;
import org.apache.kylin.engine.mr.steps.MergeCuboidMapper;

public class MergeCuboidJob
extends CuboidJob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase();
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            String jobName = this.getOptionValue(OPTION_JOB_NAME);
            logger.info("Starting: " + jobName);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)jobName);
            this.setJobClasspath(this.job, cube.getConfig());
            MergeCuboidJob.addInputDirs(this.getOptionValue(OPTION_INPUT_PATH), this.job);
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setInputFormatClass(SequenceFileInputFormat.class);
            this.job.setMapperClass(MergeCuboidMapper.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setReducerClass(CuboidReducer.class);
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.attachCubeMetadataWithDict(cube, this.job.getConfiguration());
            this.job.setNumReduceTasks(LayerReducerNumSizing.getReduceTaskNum(cube.getSegmentById(segmentID), this.getTotalMapInputMB(), -1));
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }
}

