/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.job.exception.JobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerReducerNumSizing {
    private static final Logger logger = LoggerFactory.getLogger(LayerReducerNumSizing.class);

    public static int getReduceTaskNum(CubeSegment cubeSegment, double totalMapInputMB, int level) throws ClassNotFoundException, IOException, InterruptedException, JobException {
        double adjustedCurrentLayerSizeEst;
        CubeDesc cubeDesc = cubeSegment.getCubeDesc();
        KylinConfig kylinConfig = cubeDesc.getConfig();
        double perReduceInputMB = kylinConfig.getDefaultHadoopJobReducerInputMB();
        double reduceCountRatio = kylinConfig.getDefaultHadoopJobReducerCountRatio();
        logger.info("Having per reduce MB " + perReduceInputMB + ", reduce count ratio " + reduceCountRatio + ", level " + level);
        CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, kylinConfig);
        if (level == -1) {
            double estimatedSize = cubeStatsReader.estimateCubeSize();
            adjustedCurrentLayerSizeEst = estimatedSize > totalMapInputMB ? totalMapInputMB : estimatedSize;
            logger.info("estimated size {}, input size {}, adjustedCurrentLayerSizeEst: {}", new Object[]{estimatedSize, totalMapInputMB, adjustedCurrentLayerSizeEst});
        } else if (level == 0) {
            adjustedCurrentLayerSizeEst = cubeStatsReader.estimateLayerSize(0);
            logger.info("adjustedCurrentLayerSizeEst: {}", (Object)adjustedCurrentLayerSizeEst);
        } else {
            double parentLayerSizeEst = cubeStatsReader.estimateLayerSize(level - 1);
            double currentLayerSizeEst = cubeStatsReader.estimateLayerSize(level);
            adjustedCurrentLayerSizeEst = totalMapInputMB / parentLayerSizeEst * currentLayerSizeEst;
            logger.info("totalMapInputMB: {}, parentLayerSizeEst: {}, currentLayerSizeEst: {}, adjustedCurrentLayerSizeEst: {}", new Object[]{totalMapInputMB, parentLayerSizeEst, currentLayerSizeEst, adjustedCurrentLayerSizeEst});
        }
        int numReduceTasks = (int)Math.round(adjustedCurrentLayerSizeEst / perReduceInputMB * reduceCountRatio + 0.99);
        if (cubeDesc.hasMemoryHungryMeasures()) {
            logger.info("Multiply reducer num by 4 to boost performance for memory hungry measures");
            numReduceTasks *= 4;
        }
        numReduceTasks = Math.max(kylinConfig.getHadoopJobMinReducerNumber(), numReduceTasks);
        numReduceTasks = Math.min(kylinConfig.getHadoopJobMaxReducerNumber(), numReduceTasks);
        return numReduceTasks;
    }
}

