/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.Serializable;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDCuboidBuilder
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(NDCuboidBuilder.class);
    protected String cubeName;
    protected String segmentID;
    protected CubeSegment cubeSegment;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private byte[] newKeyBodyBuf = new byte[16640];
    private ByteArray newKeyBuf = ByteArray.allocate((int)16640);

    public NDCuboidBuilder(CubeSegment cubeSegment) {
        this.cubeSegment = cubeSegment;
        this.rowKeySplitter = new RowKeySplitter(cubeSegment, 65, 256);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(cubeSegment);
    }

    public NDCuboidBuilder(CubeSegment cubeSegment, RowKeyEncoderProvider rowKeyEncoderProvider) {
        this.cubeSegment = cubeSegment;
        this.rowKeyEncoderProvider = rowKeyEncoderProvider;
        this.rowKeySplitter = new RowKeySplitter(cubeSegment, 65, 256);
    }

    public Pair<Integer, ByteArray> buildKey(Cuboid parentCuboid, Cuboid childCuboid, SplittedBytes[] splitBuffers) {
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(childCuboid);
        int offset = 0;
        long mask = Long.highestOneBit(parentCuboid.getId());
        long parentCuboidId = parentCuboid.getId();
        long childCuboidId = childCuboid.getId();
        long parentCuboidIdActualLength = 64L - (long)Long.numberOfLeadingZeros(parentCuboid.getId());
        int index = this.rowKeySplitter.getBodySplitOffset();
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & parentCuboidId) > 0L) {
                if ((mask & childCuboidId) > 0L) {
                    System.arraycopy(splitBuffers[index].value, 0, this.newKeyBodyBuf, offset, splitBuffers[index].length);
                    offset += splitBuffers[index].length;
                }
                ++index;
            }
            mask >>= 1;
            ++i;
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf.set(new byte[this.newKeyBuf.length() * 2]);
        }
        this.newKeyBuf.set(0, fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, offset), this.newKeyBuf);
        return new Pair((Object)fullKeySize, (Object)this.newKeyBuf);
    }
}

