/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCmdOutput {
    protected static final Logger logger = LoggerFactory.getLogger(HadoopCmdOutput.class);
    private final StringBuilder output;
    private final Job job;
    private String mapInputRecords;
    private String hdfsBytesWritten;
    private String rawInputBytesRead;

    public HadoopCmdOutput(Job job, StringBuilder output) {
        this.job = job;
        this.output = output;
    }

    public String getMrJobId() {
        return this.getInfo().get("mr_job_id");
    }

    public Map<String, String> getInfo() {
        if (this.job != null) {
            HashMap<String, String> status = new HashMap<String, String>();
            if (null != this.job.getJobID()) {
                status.put("mr_job_id", this.job.getJobID().toString());
            }
            if (null != this.job.getTrackingURL()) {
                status.put("yarn_application_tracking_url", this.job.getTrackingURL().toString());
            }
            return status;
        }
        return Collections.emptyMap();
    }

    public String getMapInputRecords() {
        return this.mapInputRecords;
    }

    public String getHdfsBytesWritten() {
        return this.hdfsBytesWritten;
    }

    public String getRawInputBytesRead() {
        return this.rawInputBytesRead;
    }

    public void updateJobCounter() {
        try {
            Counters counters = this.job.getCounters();
            if (counters == null) {
                String errorMsg = "no counters for job " + this.getMrJobId();
                logger.warn(errorMsg);
                this.output.append(errorMsg);
                return;
            }
            this.output.append(counters.toString()).append("\n");
            logger.debug(counters.toString());
            String bytsWrittenCounterName = "HDFS_BYTES_WRITTEN";
            String fsScheme = FileSystem.get((Configuration)this.job.getConfiguration()).getScheme();
            if ("wasb".equalsIgnoreCase(fsScheme)) {
                bytsWrittenCounterName = "WASB_BYTES_WRITTEN";
            }
            this.mapInputRecords = String.valueOf(counters.findCounter((Enum)TaskCounter.MAP_INPUT_RECORDS).getValue());
            this.hdfsBytesWritten = String.valueOf(counters.findCounter("FileSystemCounters", bytsWrittenCounterName).getValue());
            this.rawInputBytesRead = String.valueOf(counters.findCounter((Enum)FactDistinctColumnsMapper.RawDataCounter.BYTES).getValue());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            this.output.append(e.getLocalizedMessage());
        }
    }
}

