/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.kylin.engine.mr.common.DefaultX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSslProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static Logger logger = LoggerFactory.getLogger(DefaultSslProtocolSocketFactory.class);
    private SSLContext sslcontext = null;

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return this.createSocket(host, port, localAddress, localPort);
        }
        return ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, (InetAddress)localAddress, (int)localPort, (int)timeout);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(DefaultX509TrustManager.class);
    }

    public int hashCode() {
        return DefaultX509TrustManager.class.hashCode();
    }

    private static SSLContext createEasySSLContext() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new DefaultX509TrustManager(null)}, null);
            return context;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HttpClientError(e.toString());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = DefaultSslProtocolSocketFactory.createEasySSLContext();
        }
        return this.sslcontext;
    }
}

