/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.measure.hllc.HLLCounter;

public class CubeStatsWriter {
    public static void writeCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage) throws IOException {
        CubeStatsWriter.writeCuboidStatistics(conf, outputPath, cuboidHLLMap, samplingPercentage, 0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCuboidStatistics(Configuration conf, Path outputPath, Map<Long, HLLCounter> cuboidHLLMap, int samplingPercentage, int mapperNumber, double mapperOverlapRatio) throws IOException {
        Path seqFilePath = new Path(outputPath, "cuboid_statistics.seq");
        ArrayList<Long> allCuboids = new ArrayList<Long>();
        allCuboids.addAll(cuboidHLLMap.keySet());
        Collections.sort(allCuboids);
        ByteBuffer valueBuf = ByteBuffer.allocate(0x100000);
        SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)seqFilePath), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(BytesWritable.class)});
        try {
            writer.append((Writable)new LongWritable(-1L), (Writable)new BytesWritable(Bytes.toBytes((double)mapperOverlapRatio)));
            writer.append((Writable)new LongWritable(-2L), (Writable)new BytesWritable(Bytes.toBytes((int)mapperNumber)));
            writer.append((Writable)new LongWritable(0L), (Writable)new BytesWritable(Bytes.toBytes((int)samplingPercentage)));
            Iterator i$ = allCuboids.iterator();
            while (i$.hasNext()) {
                long i = (Long)i$.next();
                valueBuf.clear();
                cuboidHLLMap.get(i).writeRegisters(valueBuf);
                valueBuf.flip();
                writer.append((Writable)new LongWritable(i), (Writable)new BytesWritable(valueBuf.array(), valueBuf.limit()));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
    }
}

