/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.SumHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeStatsReader {
    private static final Logger logger = LoggerFactory.getLogger(CubeStatsReader.class);
    final CubeSegment seg;
    final int samplingPercentage;
    final int mapperNumberOfFirstBuild;
    final double mapperOverlapRatioOfFirstBuild;
    final Map<Long, HLLCounter> cuboidRowEstimatesHLL;
    final CuboidScheduler cuboidScheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubeStatsReader(CubeSegment cubeSegment, KylinConfig kylinConfig) throws IOException {
        ResourceStore store = ResourceStore.getStore((KylinConfig)kylinConfig);
        this.cuboidScheduler = new CuboidScheduler(cubeSegment.getCubeDesc());
        String statsKey = cubeSegment.getStatisticsResourcePath();
        File tmpSeqFile = this.writeTmpSeqFile(store.getResource((String)statsKey).inputStream);
        SequenceFile.Reader reader = null;
        try {
            Configuration hadoopConf = HadoopUtil.getCurrentConfiguration();
            Path path = new Path(HadoopUtil.fixWindowsPath((String)("file://" + tmpSeqFile.getAbsolutePath())));
            SequenceFile.Reader.Option seqInput = SequenceFile.Reader.file((Path)path);
            reader = new SequenceFile.Reader(hadoopConf, new SequenceFile.Reader.Option[]{seqInput});
            int percentage = 100;
            int mapperNumber = 0;
            double mapperOverlapRatio = 0.0;
            HashMap counterMap = Maps.newHashMap();
            LongWritable key = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)hadoopConf);
            BytesWritable value = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)hadoopConf);
            while (reader.next((Writable)key, (Writable)value)) {
                if (key.get() == 0L) {
                    percentage = Bytes.toInt((byte[])value.getBytes());
                    continue;
                }
                if (key.get() == -1L) {
                    mapperOverlapRatio = Bytes.toDouble((byte[])value.getBytes());
                    continue;
                }
                if (key.get() == -2L) {
                    mapperNumber = Bytes.toInt((byte[])value.getBytes());
                    continue;
                }
                if (key.get() <= 0L) continue;
                HLLCounter hll = new HLLCounter(kylinConfig.getCubeStatsHLLPrecision());
                ByteArray byteArray = new ByteArray(value.getBytes());
                hll.readRegisters(byteArray.asBuffer());
                counterMap.put(key.get(), hll);
            }
            this.seg = cubeSegment;
            this.samplingPercentage = percentage;
            this.mapperNumberOfFirstBuild = mapperNumber;
            this.mapperOverlapRatioOfFirstBuild = mapperOverlapRatio;
            this.cuboidRowEstimatesHLL = counterMap;
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(reader);
            tmpSeqFile.delete();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)reader);
        tmpSeqFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeTmpSeqFile(InputStream inputStream) throws IOException {
        File tempFile = File.createTempFile("kylin_stats_tmp", ".seq");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
            org.apache.commons.io.IOUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        finally {
            IOUtils.closeStream((Closeable)inputStream);
            IOUtils.closeStream((Closeable)out);
        }
        return tempFile;
    }

    public Map<Long, Long> getCuboidRowEstimatesHLL() {
        return CubeStatsReader.getCuboidRowCountMapFromSampling(this.cuboidRowEstimatesHLL, this.samplingPercentage);
    }

    public Map<Long, Double> getCuboidSizeMap() {
        return CubeStatsReader.getCuboidSizeMapFromRowCount(this.seg, this.getCuboidRowEstimatesHLL());
    }

    public double estimateCubeSize() {
        return SumHelper.sumDouble(this.getCuboidSizeMap().values());
    }

    public int getMapperNumberOfFirstBuild() {
        return this.mapperNumberOfFirstBuild;
    }

    public double getMapperOverlapRatioOfFirstBuild() {
        return this.mapperOverlapRatioOfFirstBuild;
    }

    public static Map<Long, Long> getCuboidRowCountMapFromSampling(Map<Long, HLLCounter> hllcMap, int samplingPercentage) {
        HashMap cuboidRowCountMap = Maps.newHashMap();
        for (Map.Entry<Long, HLLCounter> entry : hllcMap.entrySet()) {
            cuboidRowCountMap.put(entry.getKey(), entry.getValue().getCountEstimate());
        }
        return cuboidRowCountMap;
    }

    public static Map<Long, Double> getCuboidSizeMapFromRowCount(CubeSegment cubeSegment, Map<Long, Long> rowCountMap) {
        CubeDesc cubeDesc = cubeSegment.getCubeDesc();
        ArrayList rowkeyColumnSize = Lists.newArrayList();
        long baseCuboidId = Cuboid.getBaseCuboidId((CubeDesc)cubeDesc);
        Cuboid baseCuboid = Cuboid.findById((CubeDesc)cubeDesc, (long)baseCuboidId);
        List columnList = baseCuboid.getColumns();
        CubeDimEncMap dimEncMap = cubeSegment.getDimensionEncodingMap();
        for (int i = 0; i < columnList.size(); ++i) {
            rowkeyColumnSize.add(dimEncMap.get((TblColRef)columnList.get(i)).getLengthOfEncoding());
        }
        HashMap sizeMap = Maps.newHashMap();
        for (Map.Entry<Long, Long> entry : rowCountMap.entrySet()) {
            sizeMap.put(entry.getKey(), CubeStatsReader.estimateCuboidStorageSize(cubeSegment, entry.getKey(), entry.getValue(), baseCuboidId, rowkeyColumnSize));
        }
        return sizeMap;
    }

    private static double estimateCuboidStorageSize(CubeSegment cubeSegment, long cuboidId, long rowCount, long baseCuboidId, List<Integer> rowKeyColumnLength) {
        int rowkeyLength = cubeSegment.getRowKeyPreambleSize();
        KylinConfig kylinConf = cubeSegment.getConfig();
        long mask = Long.highestOneBit(baseCuboidId);
        long parentCuboidIdActualLength = 64L - (long)Long.numberOfLeadingZeros(baseCuboidId);
        int i = 0;
        while ((long)i < parentCuboidIdActualLength) {
            if ((mask & cuboidId) > 0L) {
                rowkeyLength += rowKeyColumnLength.get(i).intValue();
            }
            mask >>= 1;
            ++i;
        }
        int normalSpace = rowkeyLength;
        int countDistinctSpace = 0;
        for (MeasureDesc measureDesc : cubeSegment.getCubeDesc().getMeasures()) {
            DataType returnType = measureDesc.getFunction().getReturnDataType();
            if (measureDesc.getFunction().getExpression().equals("COUNT_DISTINCT")) {
                countDistinctSpace += returnType.getStorageBytesEstimate();
                continue;
            }
            normalSpace += returnType.getStorageBytesEstimate();
        }
        double cuboidSizeRatio = kylinConf.getJobCuboidSizeRatio();
        double cuboidSizeMemHungryRatio = kylinConf.getJobCuboidSizeCountDistinctRatio();
        double ret = (1.0 * (double)normalSpace * (double)rowCount * cuboidSizeRatio + 1.0 * (double)countDistinctSpace * (double)rowCount * cuboidSizeMemHungryRatio) / 1048576.0;
        logger.debug("Cuboid " + cuboidId + " has " + rowCount + " rows, each row size is " + (normalSpace + countDistinctSpace) + " bytes." + " Total size is " + ret + "M.");
        return ret;
    }

    private void print(PrintWriter out) {
        Map<Long, Long> cuboidRows = this.getCuboidRowEstimatesHLL();
        Map<Long, Double> cuboidSizes = this.getCuboidSizeMap();
        ArrayList<Long> cuboids = new ArrayList<Long>(cuboidRows.keySet());
        Collections.sort(cuboids);
        out.println("============================================================================");
        out.println("Statistics of " + this.seg);
        out.println();
        out.println("Cube statistics hll precision: " + this.cuboidRowEstimatesHLL.values().iterator().next().getPrecision());
        out.println("Total cuboids: " + cuboidRows.size());
        out.println("Total estimated rows: " + SumHelper.sumLong(cuboidRows.values()));
        out.println("Total estimated size(MB): " + SumHelper.sumDouble(cuboidSizes.values()));
        out.println("Sampling percentage:  " + this.samplingPercentage);
        out.println("Mapper overlap ratio: " + this.mapperOverlapRatioOfFirstBuild);
        out.println("Mapper number: " + this.mapperNumberOfFirstBuild);
        this.printKVInfo(out);
        this.printCuboidInfoTreeEntry(cuboidRows, cuboidSizes, out);
        out.println("----------------------------------------------------------------------------");
    }

    public double estimateLayerSize(int level) {
        List layeredCuboids = this.cuboidScheduler.getCuboidsByLayer();
        Map<Long, Double> cuboidSizeMap = this.getCuboidSizeMap();
        double ret = 0.0;
        for (Long cuboidId : (List)layeredCuboids.get(level)) {
            ret += cuboidSizeMap.get(cuboidId).doubleValue();
        }
        logger.info("Estimating size for layer {}, all cuboids are {}, total size is {}", new Object[]{level, StringUtils.join((Collection)((Collection)layeredCuboids.get(level)), (String)","), ret});
        return ret;
    }

    public List<Long> getCuboidsByLayer(int level) {
        List layeredCuboids = this.cuboidScheduler.getCuboidsByLayer();
        return (List)layeredCuboids.get(level);
    }

    private void printCuboidInfoTreeEntry(Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, PrintWriter out) {
        long baseCuboid = Cuboid.getBaseCuboidId((CubeDesc)this.seg.getCubeDesc());
        int dimensionCount = Long.bitCount(baseCuboid);
        CubeStatsReader.printCuboidInfoTree(-1L, baseCuboid, this.cuboidScheduler, cuboidRows, cuboidSizes, dimensionCount, 0, out);
    }

    private void printKVInfo(PrintWriter writer) {
        Cuboid cuboid = Cuboid.getBaseCuboid((CubeDesc)this.seg.getCubeDesc());
        RowKeyEncoder encoder = new RowKeyEncoder(this.seg, cuboid);
        for (TblColRef col : cuboid.getColumns()) {
            writer.println("Length of dimension " + col + " is " + encoder.getColumnLength(col));
        }
    }

    private static void printCuboidInfoTree(long parent, long cuboidID, CuboidScheduler scheduler, Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, int dimensionCount, int depth, PrintWriter out) {
        CubeStatsReader.printOneCuboidInfo(parent, cuboidID, cuboidRows, cuboidSizes, dimensionCount, depth, out);
        List children = scheduler.getSpanningCuboid(cuboidID);
        Collections.sort(children);
        for (Long child : children) {
            CubeStatsReader.printCuboidInfoTree(cuboidID, child, scheduler, cuboidRows, cuboidSizes, dimensionCount, depth + 1, out);
        }
    }

    private static void printOneCuboidInfo(long parent, long cuboidID, Map<Long, Long> cuboidRows, Map<Long, Double> cuboidSizes, int dimensionCount, int depth, PrintWriter out) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        String cuboidName = Cuboid.getDisplayName((long)cuboidID, (int)dimensionCount);
        sb.append("|---- Cuboid ").append(cuboidName);
        long rowCount = cuboidRows.get(cuboidID);
        double size = cuboidSizes.get(cuboidID);
        sb.append(", est row: ").append(rowCount).append(", est MB: ").append(CubeStatsReader.formatDouble(size));
        if (parent != -1L) {
            sb.append(", shrink: ").append(CubeStatsReader.formatDouble(100.0 * (double)cuboidRows.get(cuboidID).longValue() / (double)cuboidRows.get(parent).longValue())).append("%");
        }
        out.println(sb.toString());
    }

    private static String formatDouble(double input) {
        return new DecimalFormat("#.##").format(input);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("CubeStatsReader is used to read cube statistic saved in metadata store");
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(args[0]);
        Segments segments = cube.getSegments();
        PrintWriter out = new PrintWriter(System.out);
        for (CubeSegment seg : segments) {
            try {
                new CubeStatsReader(seg, config).print(out);
            }
            catch (Exception e) {
                logger.info("CubeStatsReader for Segment {} failed, skip it.", (Object)seg.getName());
            }
        }
        out.flush();
    }
}

